<?php

namespace App\Models\Site\StudentAdmission;

use App\Models\Academic\AcademicFeeSubHead;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteAdmissionFeeSubHeadAllocation extends SiteGlobalModel
{
    public $timestamps = true;
    protected $table = 'site_admission_fee_sub_head_allocations';


    const Academic_fee_sub_head_id = 'academic_fee_sub_head_id';
    const Amount = 'amount';
    const Site_id = 'site_id';
    const Status = 'status';
    const Site_group_id = 'site_group_id';


    protected $fillable = [
        self::Academic_fee_sub_head_id,
        self::Amount,
        self::Site_id,
        self::Status,
        self::Site_group_id,
    ];


    public $ownFields = [
        self::Academic_fee_sub_head_id,
        self::Amount,
        self::Site_id,
        self::Status,
        self::Site_group_id,
    ];

    public function academicFeeSubHead()
    {
        return $this->belongsTo(AcademicFeeSubHead::class, 'academic_fee_sub_head_id');
    }
}
