<?php

namespace App\Models\Site\StudentAdmission;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\SiteGlobalModel;
use Illuminate\Database\Eloquent\Model;

class SiteStudentAdmissionBoardApprove extends SiteGlobalModel
{
    protected $table='site_student_admission_board_approves';


    const Site_student_admission_declare_id = 'site_student_admission_declare_id';
    const Academic_group_id = 'academic_group_id';
    const Academic_version_id = 'academic_version_id';
    const Academic_shift_id = 'academic_shift_id';
    const Academic_year_id = 'academic_year_id';
    const Academic_department_id = 'academic_department_id';
    const Academic_class_id = 'academic_class_id';
    const Academic_class_group_id = 'academic_class_group_id';
    const Academic_session_id = 'academic_session_id';
    const Board_roll_number = 'board_roll_number';
    const Academic_board_id = 'academic_board_id';
    const Board_name = 'board_name';
    const Board_registration_number = 'board_registration_number';
    const Passing_year = 'passing_year';
    const First_name = 'first_name';
    const Last_name = 'last_name';
    const Father_name = 'father_name';
    const Mother_name = 'mother_name';
    const Contact_number = 'contact_number';
    const Admission_fee = 'admission_fee';
    const Total_admission_fee = 'total_admission_fee';
    const Other_fee = 'other_fee';
    const Waiver_amount = 'waiver_amount';
    const Total_fee_with_other = 'total_fee_with_other';
    const Transaction_number = 'transaction_number';
    const Second_transaction_number = 'second_transaction_number';
    const Admission_status = 'admission_status';
    const Payment_status = 'payment_status';
    const Second_payment_status = 'second_payment_status';
    const IID = 'iid';
    const Second_IID = 'second_iid';
    const Invoice_no = 'invoice_no';


    const Site_id = 'site_id';
    const Status = 'status';
    const Created_by = 'created_by';




    protected $fillable = [

        self::Academic_group_id,
        self::Site_student_admission_declare_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_year_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_session_id,
        self::Board_roll_number,
        self::Academic_board_id,
        self::Board_registration_number,
        self::Passing_year,
        self::First_name,
        self::Last_name,
        self::Mother_name,
        self::Father_name,
        self::Contact_number,

        self::Admission_fee,
        self::Total_admission_fee,
        self::Other_fee,
        self::Waiver_amount,
        self::Total_fee_with_other,
        self::Transaction_number,
        self::Second_transaction_number,
        self::Payment_status,
        self::Second_payment_status,
        self::Admission_status,
        self::IID,
        self::Second_IID,
        self::Invoice_no,

        self::Site_id,
        self::Status,
    ];



    protected $ownFields = [
        self::Academic_group_id,
        self::Site_student_admission_declare_id,
        self::Academic_version_id,
        self::Academic_shift_id,
        self::Academic_year_id,
        self::Academic_department_id,
        self::Academic_class_id,
        self::Academic_class_group_id,
        self::Academic_session_id,
        self::Board_roll_number,
        self::Academic_board_id,
        self::Board_registration_number,
        self::Passing_year,
        self::First_name,
        self::Last_name,
        self::Mother_name,
        self::Father_name,
        self::Contact_number,

        self::Admission_fee,
        self::Total_admission_fee,
        self::Other_fee,
        self::Waiver_amount,
        self::Total_fee_with_other,
        self::Transaction_number,
        self::Second_transaction_number,
        self::Payment_status,
        self::Second_payment_status,
        self::Admission_status,
        self::IID,
        self::Invoice_no,

        self::Site_id,
        self::Status,
    ];


    public function version()
    {
        return $this->belongsTo(AcademicVersion::class, self::Academic_version_id);
    }

    public function year()
    {
        return $this->belongsTo(AcademicYear::class, self::Academic_year_id);
    }



    public function shift()
    {
        return $this->belongsTo(AcademicShift::class, self::Academic_shift_id);
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class, self::Academic_department_id);
    }

    public function stClass()
    {
        return $this->belongsTo(AcademicClass::class, self::Academic_class_id);
    }

    public function classGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class, self::Academic_class_group_id);
    }

    public function session()
    {
        return $this->belongsTo(AcademicSession::class, self::Academic_session_id);
    }
}
