<?php

namespace App\Models\Site\Web\ClassRoom;

use Illuminate\Database\Eloquent\Model;

class WebsiteClassRoomLink extends Model
{

    public $timestamps = true;
    protected $table = 'website_class_room_links';
    protected $dates = ['created_at','updated_at'];
    protected $casts = ['status' => 'integer'];

    const WEBSITE_CLASS_ROOM_ID = 'website_class_room_id';
    const LINK_TYPE = 'link_type';
    const LIVE_STATUS = 'live_status';
    const LINK = 'link';
    const STATUS = 'status';


    protected $fillable = [
        self::WEBSITE_CLASS_ROOM_ID,
        self::LINK_TYPE,
        self::LIVE_STATUS,
        self::LINK,
        self::STATUS,

    ];

    public $ownFields = [
        self::WEBSITE_CLASS_ROOM_ID,
        self::LINK_TYPE,
        self::LIVE_STATUS,
        self::LINK,
        self::STATUS,
    ];


    public function classRoom()
    {
        return $this->belongsTo(ClassRoom::class);

    }



}
