<?php

namespace App\Models\Site\Web\Video;

use App\Models\Image\Photo;
use App\Models\ProjectModel;
use Illuminate\Database\Eloquent\Model;

class Video extends ProjectModel
{

    public $timestamps = true;
    protected $table = 'videos';
    protected $dates = ['created_at','updated_at'];

    protected $casts = ['status' => 'integer'];


    const TITLE = 'title';
    const VIDEO_LINK = 'video_link';
    const DESCRIPTION = 'description';
    const CREATED_BY = 'created_by';
    const DATE = 'date';
    const SITE_ID = 'site_id';
    const SITE_GROUP_ID = 'site_group_id';
    const STATUS = 'status';
    const HOME_PAGE_SHOW_STATUS = 'home_page_show_status';
    const HOME_PAGE_SHOW_MAIN_STATUS = 'home_page_show_main_status';
    const SERIAL = 'serial';



    protected $fillable = [
        self::TITLE,
        self::VIDEO_LINK,
        self::DESCRIPTION,
        self::CREATED_BY,
        self::DATE,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::STATUS,
        self::HOME_PAGE_SHOW_STATUS,
        self::HOME_PAGE_SHOW_MAIN_STATUS,
        self::SERIAL,
    ];


    public $ownFields = [
        self::TITLE,
        self::VIDEO_LINK,
        self::DESCRIPTION,
        self::CREATED_BY,
        self::DATE,
        self::SITE_ID,
        self::SITE_GROUP_ID,
        self::STATUS,
        self::HOME_PAGE_SHOW_STATUS,
        self::HOME_PAGE_SHOW_MAIN_STATUS,
        self::SERIAL,
    ];




//    public function files()
//    {
//        return $this->morphMany(Photo::class, 'imageable');
//
//    }

}

