<?php

namespace App\Models\SiteGroup\Exam;

use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\SiteGroupGlobalModel;
use App\Models\Student\StudentHistory;
use Illuminate\Database\Eloquent\Model;

class GlobalSiteGroupStudentExamPeaperToken extends Model
{
    public $timestamps = true;
    protected $table='site_group_student_exam_peaper_tokens';

    const Site_group_id='site_group_id';
    const Academic_group_id='academic_group_id';
    const Site_id='site_id';
    const Student_history_id='student_history_id';
    const Site_exam_declare_student_subject_id='site_exam_declare_student_subject_id';
    const Peaper_token_no='peaper_token_no';

    protected $fillable =[
        self::Site_group_id,
        self::Academic_group_id,
        self::Site_id,
        self::Student_history_id,
        self::Site_exam_declare_student_subject_id,
        self::Peaper_token_no,
    ];

    public function studentHistory() {

        return $this->belongsTo(GlobalStudentHistory::class,'student_history_id');

    }
}
