<?php

namespace App\Models\SiteGroup\Exam;

use Illuminate\Database\Eloquent\Model;
use App\Models\Examinations\Examination;
use App\Models\SiteGroup\SiteGroupGlobalModel;
use App\Models\SiteGroup\Settings\SiteGroupSubjectGroupConditionSettingStore;

class SiteGroupSubjectExaminationMarkStore extends SiteGroupGlobalModel
{
    protected $table='site_group_subject_examination_mark_stores';

    const Site_group_subject_group_condition_setting_id = 'site_group_subject_group_condition_setting_id';
    const Examination_id = 'examination_id';
    const Marks = 'marks';
    const Pass_marks = 'pass_marks';
    const Site_group_id = 'site_group_id';
    const Academic_group_id = 'academic_group_id';
    const Status = 'status';

    


    protected $fillable = [
        self::Site_group_subject_group_condition_setting_id,
        self::Examination_id,
        self::Marks,
        self::Pass_marks,
        self::Site_group_id,
        self::Academic_group_id,
        self::Status,
    ];

    public $ownFields = [
        self::Site_group_subject_group_condition_setting_id,
        self::Examination_id,
        self::Marks,
        self::Pass_marks,
        self::Site_group_id,
        self::Academic_group_id,
        self::Status,
    ];

    public function siteGroupSubjectExaminationExamTypeMarkStore()
    {
        return $this->hasMany(SiteGroupSubjectExaminationExamTypeMarkStore::class, 'site_group_subject_examination_mark_id');
    }

    public function siteGroupSubjectGroupConditionSettingStore()
    {
        return $this->belongsTo(SiteGroupSubjectGroupConditionSettingStore::class, 'site_group_subject_group_condition_setting_id');
    }
    public function examination()
    {
        return $this->belongsTo(Examination::class);
    }


}
