<?php

namespace App\Models\SiteGroup\Fee;

use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use Illuminate\Database\Eloquent\Model;

class SiteGroupFeeSubHeadAllocation extends Model
{
    protected $table='site_group_fee_sub_head_allocations';

    const Academic_group_id = 'academic_group_id';
    const Academic_fee_head_id = 'academic_fee_head_id';
    const Academic_fee_group_id = 'academic_fee_group_id';
    const Academic_fee_sub_head_id = 'academic_fee_sub_head_id';
    const Site_group_id = 'site_group_id';
    const Vat_amount = 'vat_amount';
    const Status = 'status';



    protected $fillable = [
        self::Academic_group_id,
        self::Academic_fee_head_id,
        self::Academic_fee_group_id,
        self::Academic_fee_sub_head_id,
        self::Site_group_id,
        self::Vat_amount,
        self::Status,

    ];
    protected $ownFields = [
        self::Academic_group_id,
        self::Academic_fee_head_id,
        self::Academic_fee_group_id,
        self::Academic_fee_sub_head_id,
        self::Site_group_id,
        self::Vat_amount,
        self::Status,
    ];


    public function academicFeeHead()
    {
        return $this->belongsTo(AcademicFeeHead::class);
    }


    public function academicFeeGroup()
    {
        return $this->belongsTo(AcademicFeeGroup::class);
    }

    public function academicFeeSubHead()
    {
        return $this->belongsTo(AcademicFeeSubHead::class);
    }


}
