<?php

namespace App\Models\SiteGroup;

use App\Models\Academic\AcademicGroup;
use App\Models\Modules\SubModule;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GlobalSiteGroup extends Model
{
    use SoftDeletes;
    //public $timestamps = true;
    public $timestamps = false;
    protected $table ='site_groups';
    protected $appends = array('academic_groups');
    protected $dates = ['deleted_at'];


    const SITE_GROUP_NAME  = 'name';
    const SITE_GROUP_ALIAS  = 'group_alias';
    const EDU_PACKAGE_ID  = 'edu_package_id';
    const SITE_GROUP_EMAIL  = 'group_email';
    const SITE_GROUP_ADDRESS  = 'group_address';
    const SITE_GROUP_PHONE = 'group_phone';
    const POSITION  = 'position';
    const STATUS  = 'status';
    const Academic_Group_IDS ='academic_group_ids';
    const GROUP_LOGO ='group_logo';

    protected $fillable =[

        self::GROUP_LOGO,
        self::SITE_GROUP_NAME,
        self::SITE_GROUP_ALIAS,
        self::EDU_PACKAGE_ID,
        self::SITE_GROUP_EMAIL,
        self::SITE_GROUP_ADDRESS,
        self::SITE_GROUP_PHONE,
        self::POSITION,
        self::STATUS,
        self::Academic_Group_IDS,
    ];

    public $ownFields =[

        self::SITE_GROUP_NAME,
        self::SITE_GROUP_ALIAS,
        self::EDU_PACKAGE_ID,
        self::SITE_GROUP_EMAIL,
        self::SITE_GROUP_ADDRESS,
        self::SITE_GROUP_PHONE,
        self::POSITION,
        self::STATUS,
        self::Academic_Group_IDS,
    ];






    public function sites()
    {
        return $this->hasMany(GlobalSiteInfo::class,'site_group_id');
    }
    public function subModules()
    {
        return $this->belongsToMany(SubModule::class,'site_group_accesses','site_group_id','sub_module_id')->withTimestamps();
    }
    public function siteGroupSettings()
    {
        return $this->hasMany(SiteGroupSetting::class,'site_group_id');
    }

    public function getAcademicGroupsAttribute()
    {
        return  $this->attributes['academic_groups']=  AcademicGroup::whereIn('id',explode(',', $this->academic_group_ids))->get();
    }




}
