<?php

namespace App\Models\SiteGroup\Role;

use Illuminate\Database\Eloquent\Model;
use App\Models\User\User;

class GlobalSiteGroupRole extends Model
{
    public $timestamps = true;
    protected $table='site_group_roles';


    const NAME    = 'name';
    const KEY  = 'key';
    const SITE_GROUP_ID  = 'site_group_id';
    const STATUS  = 'status';

    protected $fillable =[
        self::NAME,
        self::KEY,
        self::SITE_GROUP_ID,
        self::STATUS,

    ];


    public function roleAccess(){
        return $this->hasOne(GlobalSiteGroupRoleAccess::class,'site_group_role_id');
    }

//    public function accesses()
//    {
//        return $this->hasOne(SiteGroupRoleAccess::class,'site_group_role_id');
//    }


    public function users()
    {
        return $this->belongsToMany(User::class,'site_group_role_user', 'role_id', 'user_id');
    }
}
