<?php

namespace App\Models\SiteGroup\Settings;

use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGroup\SiteGroupGlobalModel;

class SiteGroupClassSessionSerialSettingsStore extends SiteGroupGlobalModel
{
    protected $table = 'site_group_class_session_serial_settings_stores';
    public $timestamps = true;

    const Academic_group_id = 'academic_group_id';
    const Site_group_id = 'site_group_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const Session_present = 'session_present';
    const Serial_no = 'serial_no';
    const SESSION_IDS = 'session_ids';
    const Batch_ids = 'batch_ids';
    const Status = 'status';

    protected $casts = [
        self::Serial_no => 'integer',
    ];

    protected $fillable = [

        self::Academic_group_id,
        self::Site_group_id,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::SESSION_IDS,
        self::Batch_ids,
        self::Session_present,
        self::Serial_no,
        self::Status,
    ];

    protected $ownField = [
        self::Academic_group_id,
        self::Site_group_id,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_CLASS_ID,
        self::SESSION_IDS,
        self::Batch_ids,
        self::Session_present,
        self::Serial_no,
        self::Status,
    ];


    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }
}
