<?php

namespace App\Models\siteGroup\Settings;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use Illuminate\Database\Eloquent\Model;
use App\Models\SiteGroup\SiteGroupGlobalModel;

class SiteGroupShiftClassGroupSectionSettingStore extends SiteGroupGlobalModel
{
    

    protected $table = 'site_group_shift_class_group_section_setting_stores';
    protected $dates = ['deleted_at'];

    public $timestamps = true;


    const Academic_group_id = 'academic_group_id';
    const Site_group_id = 'site_group_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_SECTION_IDS = 'academic_section_ids';
    const SEAT_CAPACITY = 'seat_capacity';
    const ADMISSION_SEAT_CAPACITY = 'admission_seat_capacity';
    const SEAT_EXTEND = 'seat_extend';
    const STATUS = 'status';


    protected $fillable = [
        self::Academic_group_id,
        self::Site_group_id,
        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_IDS,
        self::SEAT_CAPACITY,
        self::ADMISSION_SEAT_CAPACITY,
        self::SEAT_EXTEND,
        self::STATUS,
    ];

    public $ownfields = [

        self::ACADEMIC_SHIFT_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
//        self::ACADEMIC_GROUP_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::ACADEMIC_SECTION_IDS,
        self::SEAT_CAPACITY,
        self::ADMISSION_SEAT_CAPACITY,
        self::SEAT_EXTEND,
        self::STATUS,
    ];

    public function academicClass()
    {
        return $this->belongsTo(AcademicClass::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function academicClassGroup()
    {
        return $this->belongsTo(AcademicClassGroup::class);
    }


    public function academicDepartment()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }

    public function academicVersion()
    {
        return $this->belongsTo(AcademicVersion::class);
    }

    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }

    public function academicShift()
    {
        return $this->belongsTo(AcademicShift::class);
    }

}
