<?php

namespace App\Models\Status;

use App\Models\ProjectModel;
use App\Models\Holydays\Holyday;
use App\Models\Holydays\HolyDayType;
use App\Models\Leave\LeaveApplication;
use App\Models\Salary\SalaryRule;
use App\Models\Shift\Shift;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use App\Models\SiteGlobalModel;
use App\Models\Student\StudentClass;
use App\Models\Student\Section;
use Illuminate\Database\Eloquent\Model;

class Status extends Model
{
    public $timestamps = false;
    protected $table = 'edu_statuses';

    const NAME = 'name';
    const STATUS_KEY = 'status_key';

    protected $fillable = [
        self::NAME,
        self::STATUS_KEY,

    ];

    public $ownFields = [
        self::NAME,
        self::STATUS_KEY,

    ];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function leaveApplication()
    {
        return $this->hasMany(LeaveApplication::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function holydays()
    {
        return $this->hasMany(Holyday::class);
    }

    public function holydaytypes()
    {
        return $this->hasMany(HolyDayType::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function shifts()
    {
        return $this->hasMany(Shift::class);
    }

    public function allowances()
    {
        return $this->hasMany(SalaryRule::class);
    }

    public function siteEmployeeLeaveHistory()
    {
        return $this->hasMany(SiteEmployeeLeaveHistory::class);
    }
}
