<?php

namespace App\Models\User;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSubject;
use App\Models\Attendance\StudentAttendance;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Country\Country;
use App\Models\Designation\Designation;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Edu\EduRole;
use App\Models\Gender\Gender;
use App\Models\Image\Photo;
use App\Models\Modules\SubModule;
use App\Models\Permission\UserPermission;
use App\Models\Religion\Religion;
use App\Models\Role\HasRoles;
use App\Models\Site\Accounts\SiteAccountsEmployeeSalary;
use App\Models\Site\Employee\StudentAssignToTeacher;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Web\Message\Message;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\Role\SiteGroupRole;
use App\Models\Student\PublicStudentHistory;
use App\Models\Thana\Thana;
use Dimsav\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class PublicUser extends Model
{
    use Translatable, HasRoles, SoftDeletes;

    public $translationModel = 'App\Models\User\UserTranslation';
    public $translationForeignKey = 'user_id';
    public $timestamps = true;


    protected $table = 'users';
    protected $dates = ['deleted_at'];
    protected $appends = array('full_name');

    const ID = 'id';
    const EMPLOYEE_ID = 'employee_id';
    const USERNAME = 'username';
    const EMAIL = 'email';
    const USER_TYPE = 'user_type';
    const FIRST_NAME = 'first_name';
    const LAST_NAME = 'last_name';
    const FATHER_NAME = 'father_name';
    const MOTHER_NAME = 'mother_name';
    const SPOUSE_NAME = 'spouse_name';
    const PASSWORD = 'password';
    const LAST_LOGIN = 'last_login';
    const NAME_NATIVE_LANGUAGE = 'name_native_language';
    const CONTACT_NUMBER = 'contact_number';
    const BLOOD_GROUP_ID = 'blood_group_id';
    const FATHER_OCCUPATION_ID = 'father_occupation_id';
    const FATHER_YEARLY_INCOME = 'father_yearly_income';
    const FATHER_CONTACT_NUMBER = 'father_contact_number';
    const FATHER_EMAIL = 'father_email';
    const MOTHER_OCCUPATION_ID = 'mother_occupation_id';
    const MOTHER_YEARLY_INCOME = 'mother_yearly_income';
    const MOTHER_CONTACT_NUMBER = 'mother_contact_number';
    const MOTHER_EMAIL = 'mother_email';
    const PRESENT_COUNTRY_ID = 'present_country_id';
    const PRESENT_DIVISION_ID = 'present_division_id';
    const PRESENT_DISTRICT_ID = 'present_district_id';
    const PRESENT_THANA_ID = 'present_thana_id';
    const ADDRESS = 'address';
    const PERMANENT_COUNTRY_ID = 'permanent_country_id';
    const PERMANENT_DIVISION_ID = 'permanent_division_id';
    const PERMANENT_DISTRICT_ID = 'permanent_district_id';
    const PERMANENT_THANA_ID = 'permanent_thana_id';
    const PERMANENT_ADDRESS = 'permanent_address';
    const GENDER_ID = 'gender_id';
    const RELIGION_ID = 'religion_id';
    const ACADEMIC_VERSION_ID = 'academic_version_id';
    const ACADEMIC_YEAR_ID = 'academic_year_id';
    const ACADEMIC_RESIDANCE_ID = 'academic_residence_id';
    const ACADEMIC_SESSION_ID = 'academic_session_id';
    const ACADEMIC_STUDENT_CATEGORY_ID = 'academic_student_category_id';
    const ACADEMIC_STUDENT_TYPE_ID = 'academic_student_type_id';
    const ACADEMIC_STUDENT_ADMISSION_TYPE_ID = 'academic_student_admission_type_id';
    const ACADEMIC_QUATA_ID = 'academic_quata_id';
    const STUDENT_REGISTRATION_NUMBER = 'student_registration_number';
    const BOARD_REGISTRATION_NUMBER = 'board_registration_number';
    const RELIGION_SUBJECT_ID = 'religion_subject_id';
    const COMPULSORY_SUBJECT_IDS = 'compulsory_subject_ids';
    const OPTIONAL_SUBJECT_IDS = 'optional_subject_ids';

    const ACADEMIC_SUBJECT_IDs = 'academic_subject_ids';
    const GENERAL_MARKINGLESS_SUBJECT_IDs = 'general_markingless_subject_ids';
    const SELECTIVE_MARKINGLESS_SUBJECT_IDs = 'selective_markingless_subject_ids';

    const GUARDIAN_STUDENT_RELATION_ID = 'guardian_student_relation_id';
    const ACADEMIC_CLASS_ID = 'academic_class_id';
    const SITE_BATCH_DETAIL_ID = 'site_batch_detail_id';
    const ACADEMIC_DEPARTMENT_ID = 'academic_department_id';
    const ACADEMIC_SECTION_ID = 'academic_section_id';
    const ACADEMIC_CLASS_GROUP_ID = 'academic_class_group_id';
    const STUDENT_ROLL_NUMBER = 'student_roll_number';
    const PROFESSION = 'profession';
    const LOCAL_GUARDIAN_USER_ID = 'local_guardian_user_id';
    const DEPARTMENT_ID = 'department_id';
    const DESIGNATION_ID = 'designation_id';
    const EMP_CATEGORY_ID = 'emp_category_id';
    const EMP_POSITION_ID = 'emp_position_id';
    const ACADEMIC_SHIFT_ID = 'academic_shift_id';
    const BIOMETRIC_ID = 'biometric_id';
    const FINGER_TAKEN = 'finger_taken';
    const ATTENDANCE_SMS = 'attendance_sms';
    const DEPT_JOIN_DATE = 'dept_join_date';
    const PHONE = 'phone';
    const EMERGENCY_CONTACT = 'emergency_contact';
    const NID_NUMBER = 'nid_number';
    const PASSPORT_NO = 'passport_no';
    const BIRTH_CERTIFICATE_NO = 'birth_certificate_no';
    const STATUS = 'status';
    const REMEMBER_TOKEN = 'remember_token';
    const DATE_OF_BIRTH = 'date_of_birth';
    const DELETED_AT = 'deleted_at';

    const NATIONALITY = 'nationality';
    const INSTITUTE_JOINING_DATE = 'institute_joining_date';
    const NTRC_REGISRATION_NUMBER = 'ntrc_registration_number';
    const Student_roll_number_prefix = 'student_roll_number_prefix';

    const Present_id_card_code = 'present_id_card_code';
    const Ex_id_card_code = 'ex_id_card_code';


    public $translatedAttributes = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::ADDRESS,
        self::SPOUSE_NAME,
        self::MOTHER_NAME,
        self::FATHER_NAME,
        self::PERMANENT_ADDRESS

    ];


    protected $fillable = [
        self::FIRST_NAME,
        self::LAST_NAME,
        self::USER_TYPE,
        self::FATHER_NAME,
        self::MOTHER_NAME,
        self::SPOUSE_NAME,
        self::EMPLOYEE_ID,
        self::USERNAME,
        self::EMAIL,
        self::PASSWORD,
        self::LAST_LOGIN,
        self::NAME_NATIVE_LANGUAGE,
        self::CONTACT_NUMBER,
        self::BLOOD_GROUP_ID,
        self::FATHER_OCCUPATION_ID,
        self::FATHER_YEARLY_INCOME,
        self::FATHER_CONTACT_NUMBER,
        self::FATHER_EMAIL,
        self::MOTHER_OCCUPATION_ID,
        self::MOTHER_YEARLY_INCOME,
        self::MOTHER_CONTACT_NUMBER,
        self::MOTHER_EMAIL,
        self::PRESENT_COUNTRY_ID,
        self::PRESENT_DIVISION_ID,
        self::PRESENT_DISTRICT_ID,
        self::PRESENT_THANA_ID,
        self::ADDRESS,
        self::PERMANENT_COUNTRY_ID,
        self::PERMANENT_DIVISION_ID,
        self::PERMANENT_DISTRICT_ID,
        self::PERMANENT_THANA_ID,
        self::PERMANENT_ADDRESS,
        self::GENDER_ID,
        self::RELIGION_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_RESIDANCE_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_STUDENT_CATEGORY_ID,
        self::ACADEMIC_STUDENT_TYPE_ID,
        self::ACADEMIC_STUDENT_ADMISSION_TYPE_ID,
        self::ACADEMIC_QUATA_ID,
        self::STUDENT_REGISTRATION_NUMBER,
        self::BOARD_REGISTRATION_NUMBER,
        self::RELIGION_SUBJECT_ID,
        self::ACADEMIC_SUBJECT_IDs,
        self::COMPULSORY_SUBJECT_IDS,
        self::OPTIONAL_SUBJECT_IDS,
        self::GENERAL_MARKINGLESS_SUBJECT_IDs,
        self::SELECTIVE_MARKINGLESS_SUBJECT_IDs,
        self::GUARDIAN_STUDENT_RELATION_ID,
        self::ACADEMIC_CLASS_ID,
        self::SITE_BATCH_DETAIL_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::STUDENT_ROLL_NUMBER,
        self::PROFESSION,
        self::LOCAL_GUARDIAN_USER_ID,
        self::DEPARTMENT_ID,
        self::DESIGNATION_ID,
        self::EMP_CATEGORY_ID,
        self::EMP_POSITION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::BIOMETRIC_ID,
        self::FINGER_TAKEN,
        self::ATTENDANCE_SMS,
        self::DEPT_JOIN_DATE,
        self::PHONE,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NO,
        self::BIRTH_CERTIFICATE_NO,
        self::STATUS,
        self::REMEMBER_TOKEN,
        self::DATE_OF_BIRTH,
        self::DELETED_AT,
        self::NATIONALITY,
        self::INSTITUTE_JOINING_DATE,
        self::NTRC_REGISRATION_NUMBER,
        self::Student_roll_number_prefix,

        self::Present_id_card_code,
        self::Ex_id_card_code

//        self::USER_NAME,
//        self::FIRST_NAME,
//        self::LAST_NAME,
//        self::GENDER,
//        self::RELIGION,
//        self::DEPARTMENT,
//        self::BIOMETRIC,
//        self::PHONE,
//        self::ADDRESS,
//        self::STATUS,
//        self::EMAIL,
//        self::PASSWORD,
//        self::DESIGNATION,
//        self::EMPCATEGORY,
//        self::EMPPOSITION,
//        self::DETP_JOIN_DATE,
//        self::PERMANENT_ADDRESS,
//        self::SHIFT,
//        self::EMPLOYEE_ID,
//        self::BONUS,
//        self::GUARDIAN,
//        self::NID_NUMBER,
//        self::PASSPORT_NUMBER,
//        self::EMERGENCY_CONTACT,
//        self::BIRTH_CERTIFICATE_NUMBER
    ];

  
    public $ownFields = [
        self::FIRST_NAME,
        self::USER_TYPE,
        self::LAST_NAME,
        self::FATHER_NAME,
        self::MOTHER_NAME,
        self::SPOUSE_NAME,
        self::EMPLOYEE_ID,
        self::USERNAME,
        self::EMAIL,
        self::PASSWORD,
        self::LAST_LOGIN,
        self::NAME_NATIVE_LANGUAGE,
        self::CONTACT_NUMBER,
        self::BLOOD_GROUP_ID,
        self::FATHER_OCCUPATION_ID,
        self::FATHER_YEARLY_INCOME,
        self::FATHER_CONTACT_NUMBER,
        self::FATHER_EMAIL,
        self::MOTHER_OCCUPATION_ID,
        self::MOTHER_YEARLY_INCOME,
        self::MOTHER_CONTACT_NUMBER,
        self::MOTHER_EMAIL,
        self::PRESENT_COUNTRY_ID,
        self::PRESENT_DIVISION_ID,
        self::PRESENT_DISTRICT_ID,
        self::PRESENT_THANA_ID,
        self::ADDRESS,
        self::PERMANENT_COUNTRY_ID,
        self::PERMANENT_DIVISION_ID,
        self::PERMANENT_DISTRICT_ID,
        self::PERMANENT_THANA_ID,
        self::PERMANENT_ADDRESS,
        self::GENDER_ID,
        self::RELIGION_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_STUDENT_CATEGORY_ID,
        self::ACADEMIC_STUDENT_TYPE_ID,
        self::ACADEMIC_STUDENT_ADMISSION_TYPE_ID,
        self::ACADEMIC_QUATA_ID,
        self::ACADEMIC_RESIDANCE_ID,
        self::STUDENT_REGISTRATION_NUMBER,
        self::BOARD_REGISTRATION_NUMBER,
        self::RELIGION_SUBJECT_ID,
        self::ACADEMIC_SUBJECT_IDs,
        self::COMPULSORY_SUBJECT_IDS,
        self::OPTIONAL_SUBJECT_IDS,
        self::GENERAL_MARKINGLESS_SUBJECT_IDs,
        self::SELECTIVE_MARKINGLESS_SUBJECT_IDs,
        self::GUARDIAN_STUDENT_RELATION_ID,
        self::ACADEMIC_CLASS_ID,
        self::SITE_BATCH_DETAIL_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::STUDENT_ROLL_NUMBER,
        self::PROFESSION,
        self::LOCAL_GUARDIAN_USER_ID,
        self::DEPARTMENT_ID,
        self::DESIGNATION_ID,
        self::EMP_CATEGORY_ID,
        self::EMP_POSITION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::BIOMETRIC_ID,
        self::FINGER_TAKEN,
        self::ATTENDANCE_SMS,
        self::DEPT_JOIN_DATE,
        self::PHONE,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NO,
        self::BIRTH_CERTIFICATE_NO,
        self::STATUS,
        self::REMEMBER_TOKEN,
        self::DATE_OF_BIRTH,
        self::DELETED_AT,
        self::NATIONALITY,
        self::INSTITUTE_JOINING_DATE,
        self::NTRC_REGISRATION_NUMBER,
        self::Student_roll_number_prefix,

        self::Present_id_card_code,
        self::Ex_id_card_code

    ];
    public $gurdianFields = [
        self::USER_TYPE,
        self::USERNAME,
        self::EMPLOYEE_ID,
        self::GENDER_ID,
        self::RELIGION_ID,
        self::PHONE,
        self::EMAIL,
        self::DATE_OF_BIRTH,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NO,
        self::BIRTH_CERTIFICATE_NO
    ];
    public $studentFields = [
        self::USERNAME,
        self::USER_TYPE,
        self::FIRST_NAME,
        self::LAST_NAME,
        self::FATHER_NAME,
        self::MOTHER_NAME,
        self::LAST_LOGIN,
        self::NAME_NATIVE_LANGUAGE,
        self::EMAIL,
        self::CONTACT_NUMBER,
        self::BLOOD_GROUP_ID,
        self::FATHER_OCCUPATION_ID,
        self::FATHER_YEARLY_INCOME,
        self::FATHER_CONTACT_NUMBER,
        self::FATHER_EMAIL,
        self::MOTHER_OCCUPATION_ID,
        self::MOTHER_YEARLY_INCOME,
        self::MOTHER_CONTACT_NUMBER,
        self::MOTHER_EMAIL,
        self::PRESENT_COUNTRY_ID,
        self::PRESENT_DIVISION_ID,
        self::PRESENT_DISTRICT_ID,
        self::PRESENT_THANA_ID,
        self::ADDRESS,
        self::PERMANENT_COUNTRY_ID,
        self::PERMANENT_DIVISION_ID,
        self::PERMANENT_DISTRICT_ID,
        self::PERMANENT_THANA_ID,
        self::PERMANENT_ADDRESS,
        self::GENDER_ID,
        self::RELIGION_ID,
        self::ACADEMIC_VERSION_ID,
        self::ACADEMIC_YEAR_ID,
        self::ACADEMIC_DEPARTMENT_ID,
        self::ACADEMIC_SESSION_ID,
        self::ACADEMIC_STUDENT_CATEGORY_ID,
        self::ACADEMIC_STUDENT_TYPE_ID,
        self::ACADEMIC_STUDENT_ADMISSION_TYPE_ID,
        self::ACADEMIC_QUATA_ID,
        self::ACADEMIC_RESIDANCE_ID,
        self::STUDENT_REGISTRATION_NUMBER,
        self::BOARD_REGISTRATION_NUMBER,
        self::RELIGION_SUBJECT_ID,
        self::ACADEMIC_SUBJECT_IDs,
        self::COMPULSORY_SUBJECT_IDS,
        self::OPTIONAL_SUBJECT_IDS,
        self::GENERAL_MARKINGLESS_SUBJECT_IDs,
        self::SELECTIVE_MARKINGLESS_SUBJECT_IDs,
        self::GUARDIAN_STUDENT_RELATION_ID,
        self::ACADEMIC_CLASS_ID,
        self::SITE_BATCH_DETAIL_ID,
        self::ACADEMIC_SECTION_ID,
        self::ACADEMIC_CLASS_GROUP_ID,
        self::STUDENT_ROLL_NUMBER,
        self::PROFESSION,
        self::LOCAL_GUARDIAN_USER_ID,
        self::DEPARTMENT_ID,
        self::DESIGNATION_ID,
        self::EMP_CATEGORY_ID,
        self::EMP_POSITION_ID,
        self::ACADEMIC_SHIFT_ID,
        self::DEPT_JOIN_DATE,
        self::PHONE,
        self::EMERGENCY_CONTACT,
        self::NID_NUMBER,
        self::PASSPORT_NO,
        self::BIRTH_CERTIFICATE_NO,
        self::STATUS,
        self::REMEMBER_TOKEN,
        self::DATE_OF_BIRTH,
        self::DELETED_AT,
        self::Student_roll_number_prefix,

        self::Present_id_card_code,
        self::Ex_id_card_code
    ];
    public $studentHistoryFields = [
        self::DEPARTMENT_ID,
        self::ACADEMIC_CLASS_ID,
        self::ACADEMIC_SECTION_ID,
        self::STUDENT_ROLL_NUMBER,
        self::LOCAL_GUARDIAN_USER_ID,
    ];
    public $employeeHistoryFields = [
        self::DEPARTMENT_ID,
        self::EMP_CATEGORY_ID,
        self::EMP_POSITION_ID,
        self::DEPT_JOIN_DATE,
        self::ACADEMIC_SHIFT_ID
    ];
    public $teachersHistoryFields = [
        self::DEPARTMENT_ID,
        self::NID_NUMBER,
        self::DEPT_JOIN_DATE,
        self::ACADEMIC_SHIFT_ID
    ];

    public function getFullNameAttribute()
    {
        return $this->attributes['full_name'] = ($this->first_name ?? '') . ' ' . ($this->last_name ?? '');

    }

    public function getStudentFullRollNumberAttribute()
    {
        return $this->attributes['student_full_roll_number'] = ($this->student_roll_number_prefix ??'') . ($this->student_roll_number);
    }


//mutator

    public function setDateOfBirthAttribute($value)
    {
        $middle = strtotime($value);
        $new_date = date('Y-m-d', $middle);
        $this->attributes['date_of_birth'] = $new_date;
    }

    public function eduRoles()
    {
        return $this->belongsToMany(EduRole::class, 'edu_role_user', 'user_id', 'role_id');
    }


    public function siteInfoes()
    {
        return $this->belongsToMany(GlobalSiteInfo::class, 'site_info_user', 'user_id', 'site_id');
    }


    // public function message()
    // {
    //     return $this->hasOne(Message::class);
    // }


    public function presentCountry()
    {
        return $this->belongsTo(Country::class, 'present_country_id');
    }

    public function permanentCountry()
    {
        return $this->belongsTo(Country::class, 'permanent_country_id');
    }

    public function presentDivision()
    {
        return $this->belongsTo(Division::class, 'present_division_id');
    }

    public function permanentDivision()
    {
        return $this->belongsTo(Division::class, 'permanent_division_id');
    }

    public function presentDistrict()
    {
        return $this->belongsTo(District::class, 'present_district_id');
    }

    public function permanentDistrict()
    {
        return $this->belongsTo(District::class, 'permanent_district_id');
    }

    public function presentThana()
    {
        return $this->belongsTo(Thana::class, 'present_thana_id');
    }

    public function permanentThana()
    {
        return $this->belongsTo(Thana::class, 'permanent_thana_id');
    }


    public function bloodGroup()
    {
        return $this->belongsTo(BloodGroup::class, 'blood_group_id');
    }


    public function studentHistories()
    {
        return $this->hasMany(PublicStudentHistory::class);
    }

    public function studentSingleHistories()
    {
        return $this->hasOne(PublicStudentHistory::class);
    }

    public function religion()
    {
        return $this->belongsTo(Religion::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\MorphMany
     */
    public function photo()
    {
        return $this->morphMany(Photo::class, 'imageable');
    }

    public function photos()
    {
        return $this->hasMany(Photo::class);
    }

    // public function latestPhoto()
    // {
    //     return $this->hasOne(Photo::class, 'imageable_id')->orderBy('id', 'DESC');
    // }

    public function latestPhoto()
    {
        return $this->hasOne(Photo::class, 'imageable_id')
            ->where('imageable_type','App\Models\Site\Student\Student')
            ->orderBy('id', 'DESC');
    }

    public function latestPhotoName()
    {
        return $this->latestPhoto()->select(['name']);
    }


    public function stClass()
    {
        return $this->belongsTo(AcademicClass::class, 'academic_class_id');
    }

    public function department()
    {
        return $this->belongsTo(AcademicDepartment::class);
    }


    public function designation()
    {
        return $this->belongsTo(Designation::class);
    }


    public function section()
    {
        return $this->belongsTo(AcademicSection::class, 'academic_section_id');
    }

    public function getCompulsorySubjectIdsAttribute($values)
    {
        return $this->attributes['compulsory_subject_ids'] = AcademicSubject::whereIn('id', explode(',', $values))->get();

    }

    public function getOptionalSubjectIdsAttribute($values)
    {
        return $this->attributes['optional_subject_ids'] = AcademicSubject::whereIn('id', explode(',', $values))->get();

    }


    public function getSelectiveMarkinglessSubjectIdsAttribute($values)
    {
        return $this->attributes['selective_markingless_subject_ids'] = AcademicSubject::whereIn('id', explode(',', $values))->get();

    }

    /**
     * more than one user should belong to a gender
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }


    public function routeNotificationForNexmo($notification)
    {
        return $this->phone;
    }

 
}
