<?php

namespace App\Models\WebSite;

use App\Models\Menu\Menu;
use Illuminate\Database\Eloquent\Model;

class WebsiteMenu extends Model
{
    public $timestamps = true;


    const MENU_ID = 'menu_id';
    const PARENT_ID = 'parent_id';
    const SERIAL = 'serial';
    const SHOW_ICON = 'show_icon';
    const TYPE = 'type';
    const TYPE_ID = 'type_id';
    const STATUS = 'status';

    protected $fillable = [

        self::MENU_ID,
        self::PARENT_ID,
        self::SHOW_ICON,
        self::SERIAL,
        self::STATUS,

    ];
    public $ownFields = [

        self::PARENT_ID,
        self::SERIAL,
        self::SHOW_ICON,
        self::STATUS,
    ];

    public function children()
    {
        return $this->hasMany(WebsiteMenu::class, 'parent_id');
    }

    public function menu()
    {
        return $this->belongsTo(Menu::class, 'menu_id');
    }

}
