<?php

namespace App\Notifications\Site;

use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Notice\Notice;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class GlobalStudentPaymentHistoryNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public $siteStudentFeePaymentHistory;
    public $route;

    public function __construct(GlobalSiteStudentFeePaymentHistory $siteStudentFeePaymentHistory, $route)
    {
        //dd( $siteStudentFeeDemandSlipDetails);
        $this->siteStudentFeePaymentHistory=$siteStudentFeePaymentHistory;

        $this->route=$route;
       // dd('kooo');
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
//        return $this->siteStudentFeeDemandSlipDetails;

//        $fee_fine = SiteStudentFeeFine::where('site_student_fee_payment_history_id', $this->siteStudentFeePaymentHistory->id)->get();
//        $total_fine = 0;
//        if(count($fee_fine)){
//            foreach ($fee_fine as $key => $value){
//                $total_fine+= $value->fine_amount;
//            }
//        }
//
//        $total_amount = $this->siteStudentFeePaymentHistory->total_amount + $total_fine;

         return [
             'id'=>$this->siteStudentFeePaymentHistory->id,
             'link'=>$this->route.'/'.$this->id,//route('site-notice-view',[$this->id]),
             'title' => 'Payment Given',
             'data' => ' User ID: '.$this->siteStudentFeePaymentHistory->studentHistory->student->username.',<br> Paid Amount: '. $this->siteStudentFeePaymentHistory->paid_amount . '(TK),<br> Due Amount: '. $this->siteStudentFeePaymentHistory->due_amount.'(TK),<br> Payment Date: '. $this->siteStudentFeePaymentHistory->payment_date,
         ];

    }
}
