<?php

namespace App\Providers;

use App\Models\Edu\Issue\IssueDetail;
use DB;
use Debugbar;
use Illuminate\Queue\Events\JobFailed;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Queue;
use Route;
use Schema;
use Illuminate\Queue\Events\JobProcessed;
use Illuminate\Queue\Events\JobProcessing;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     *
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        date_default_timezone_set('Asia/Dhaka');
        Debugbar::disable();

        //config(['app.timezone' => 'America/Chicago']);


        /*   dd(request()->route()->getName());

            \Config::set('request.subdomain', Route::getCurrentRoute());



           // \Config::set('app.url', 'http://eduworlderp.test');
           \Config::set('app.url', 'http://eduworlderp.test');

           dd(\Config::get('request.subdomain'));*/


     /*   DB::listen(function ($query) {
            \Log::info(
                $query->sql
            );
        });*/
     /*   DB::listen(function ($query) {
            \Log::info(
            //   $query->bindings,
                $query->time
            );
        });*/


        Queue::before(function (JobProcessing $event) {
            // $event->connectionName
            // $event->job;
            // $event->job->payload()

            // new comment for IssueDetais for rayhan

            // $issue = new  IssueDetail();
            // $issue->issuer_type = 'edu';
            // $issue->issue_type = 'job';
            // $issue->issue_details = 'JobProcessing: ' . json_encode($event->job->payload());
            // $issue->save();


        });

        Queue::failing(function (JobFailed $event) {

            $issue = new  IssueDetail();
            $issue->issuer_type = 'edu';
            $issue->issue_type = 'job';
            $issue->issue_details = 'JobFailed: ' . json_encode($event->job->payload());
            $issue->save();
        });

        Queue::after(function (JobProcessed $event) {
            // $event->connectionName
            // $event->job
            // $event->job->payload()

            $issue = new  IssueDetail();
            $issue->issuer_type = 'edu';
            $issue->issue_type = 'job';
            $issue->issue_details = 'JobProcessed: ' . json_encode($event->job->payload());
            $issue->save();


        });


    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        if ($this->app->environment() !== 'production') {
            $this->app->register(\Barryvdh\LaravelIdeHelper\IdeHelperServiceProvider::class);
            $this->app->register(\Barryvdh\Debugbar\ServiceProvider::class);

        }


    }
}
