<?php

namespace App\Traits\DB;

use Exception;
use File;
use Mail;

trait DatabaseBackupTrait
{
    public function sendDbFileThroughEmail()
    {
        try {


            $path = storage_path('backups/');
            $files = File::files($path);

            if (!count($files)) {
                return false;
            }

            $file = $files[0];

            // dd(date('d M Y h:i:s A',$file->getCTime()));


            $data = array(
                'company' => 'Edu world',
                'category' => 'DB Backup File',
                'file_created' => date('d M Y h:i:s A', $file->getCTime()),

            );

            Mail::send('mail.send-db-mail', compact('data'), function ($message) use ($data, $file) {
                $message->to('ii@gmail.com')->subject($data['company'] . ' - ' . $data['category']);
                $message->attach($file->getRealPath());

            });

            return true;
        } catch (Exception $exception) {
            return false;
        }

    }


    public function dbback()
    {

        /*  config('database.connections.mysql.username'),
              config('database.connections.mysql.password'),
              config('database.connections.mysql.database'),
          */

    }


    /**
     * this function create the zip file with the database dump and save it on the ftp server
     * @return
     */
    protected function createZIP()
    {

// Set permissions to 777
        chmod($this->config['folder'], 0777);

// create zip file
        $zip = new ZipArchive();
// Create file name
        $this->datei = $this->config['folder'] . $this->config['mysql'][3] . "_" . date("j_F_Y_g:i_a") . ".zip";

// Checking if file could be created
        if ($zip->open($this->datei, ZIPARCHIVE::CREATE) !== TRUE) {
            exit("cannot open <" . $this->datei . ">\n");
        }

// add mysql dump to zip file
        $zip->addFromString("dump.sql", $this->dump);
// close file
        $zip->close();

// Check whether file has been created
        if (!file_exists($this->datei)) {
            die("The ZIP file could not be created.");
        }

        echo "
<p>
    <small>The zip was created.</small>
</p>";
    }
}