<?php

namespace App\Traits\Site\Duty\Employee;

use App\Models\Event\Event;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\SiteEmployeeSiteShift;
use App\Models\Site\EmployeeDuty\SiteEmployeeDutyHistory;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use App\Models\User\EmployeeHistory;
use Carbon\CarbonPeriod;
use Error;
use Exception;

trait DutyFunction
{

    public function checkDutyIfExist($data_range,$employee_history_id)
    {
        $st_date = $data_range['start'];
        $ed_date = $data_range['end'];

        $duty_history = SiteEmployeeDutyHistory::where('employee_history_id', $employee_history_id)
            ->where('status', true)
            ->get();

        $data=false;
        if(count($duty_history)){
            $period = CarbonPeriod::create($st_date, $ed_date);
            foreach ($period as $date) {
                $dd = $date->format('Y-m-d');

                foreach ($duty_history as $key => $value){
                    $start_date = $value->from_date;
                    $end_date = $value->to_date;
                    $prd = CarbonPeriod::create($start_date, $end_date);

                    foreach ($prd as $dt){
                        $ddd = $dt->format('Y-m-d');
                        if($dd == $ddd){
                            $data=true;
                        }
                    }

                }

            }

        }

        return $data;
    }

    private function getEmployeeInDuty($employeeID, $search_date)
    {

        $employee_history = EmployeeHistory::where('user_id', $employeeID)
            ->where('status', 1)
            ->orderBy('id', 'DESC')
            ->first();

        $duty_history = SiteEmployeeDutyHistory::where('employee_history_id', $employee_history->id)
            ->where('status', 1)
            //->where('leave_status', 'approved')
            ->get();

        if (count($duty_history)) {
            foreach ($duty_history as $key => $value) {
                $start_date = $value->from_date;
                $end_date = $value->to_date;

                $period = CarbonPeriod::create($start_date, $end_date);
                foreach ($period as $date) {
                    $dd = $date->format('Y-m-d');
                    if ($dd == $search_date) {

                        return true;

                    }
                }

            }
            return false;
        }

    }



    private function getTotalDutyByDay($date, $shift_id, $employee)
    {
        $emp_ids = $employee->pluck('id');

        $emp_history_ids = EmployeeHistory::whereIn('user_id', $emp_ids)->pluck('id');

        $emp_leave_details = SiteEmployeeDutyHistory::whereIn('employee_history_id', $emp_history_ids)->get();
        $leave_days = 0;
        if (count($emp_leave_details)) {

            foreach ($emp_leave_details as $key => $value) {
                $start_date = $value->from_date;
                $end_date = $value->to_date;

                $period = CarbonPeriod::create($start_date, $end_date);
                foreach ($period as $apply_date) {
                    $dd = $apply_date->format('Y-m-d');
                    if ($dd == $date) {

                        $leave_days += 1;

                    }
                }

            }

        }
        return $leave_days;

    }

}