<?php

namespace App\Traits\Site\Fee;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Payment\SiteStudentOnlinePaymentDetails;
use App\Models\Site\SiteInfo;
use App\Models\Student\StudentHistory;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\User\GlobalUser;
use App\Traits\SmsFunctionsTrait;
use App\Jobs\Site\PaymentHistoryJob;
use App\Models\Session\PaymentSession;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeGatewaySetting;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Fee\GlobalSiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\Site\Payment\PaymentGatewayTrait;
use App\Traits\Site\Payment\StudentSonaliPayTransactionTrait;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use Error;
use Exception;
use Response;
use Session;
use DB;

trait SonaliPayStudentFeeTrait
{


    use StudentSonaliPayTransactionTrait, StudentFeeTrait;


    function detectMixedLanguage($text) {
        $containsBangla = preg_match('/[\x{0980}-\x{09FF}]/u', $text);
        $containsEnglish = preg_match('/[a-zA-Z]/', $text);
    
        if ($containsBangla && $containsEnglish) {
            return 'mixed';
        } elseif ($containsBangla) {
            return 'bangla';
        } elseif ($containsEnglish) {
            return 'english';
        }
    
        return 'Unknown';
    }

    private function checkGatewaySubheadSettings($demand_slip_details){

        $site_id            =   $demand_slip_details->site_id;
        $academic_group_id  =   $demand_slip_details->academic_group_id;
        $slip_generated_ids =   explode(',',$demand_slip_details->site_student_fee_generate_ids);

        $feeGeneratedList=GlobalSiteStudentFeeGenerate::where('site_id',$site_id)
                ->whereIn('id',$slip_generated_ids)
                ->get();

        foreach($feeGeneratedList as $feeGenerated){
        $check_data=GlobalSiteStudentFeeGatewaySetting::where('status',true)
            ->where('site_id',$site_id) 
            ->where('academic_group_id',$academic_group_id) 
            ->where('fee_type_key','student_fee') 
            ->where('academic_payment_method_key','sonali_pay')
            ->where('academic_fee_head_id', $feeGenerated->academic_fee_head_id)
            ->where('academic_fee_sub_head_id', $feeGenerated->academic_fee_sub_head_id)
            ->first(); 

            if(!$check_data){
                return false;
            }
        }

        return true;

    }


    private function gatewayAccountWiseAmount($demand_slip_details){

        
        $site_id                =   $demand_slip_details->site_id;
        $academic_group_id      =   $demand_slip_details->academic_group_id;

        $checkPrevClassSlip = GlobalSiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id', $demand_slip_details->student_history_id)
            ->where('previous_academic_class_due_status', true)
            ->where('site_id', $site_id)
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->first(); 

        $prev_slip_generated_ids = [];
        $prev_generated_waiver_ids = [];

        if($checkPrevClassSlip){
            $prev_slip_generated_ids = explode(',',$checkPrevClassSlip->site_student_fee_generate_ids);
            $prev_generated_waiver_ids = explode(',',$checkPrevClassSlip->site_student_fee_waiver_offer_history_ids);
        }           

        $slip_generated_ids     =   explode(',',$demand_slip_details->site_student_fee_generate_ids);
        $merged_fee_generate_id_splite = array_merge($slip_generated_ids, $prev_slip_generated_ids);


        $generated_waiver_ids   =   explode(',',$demand_slip_details->site_student_fee_waiver_offer_history_ids);
        $merged_fee_generate_waiver_id_splite = array_merge($generated_waiver_ids, $prev_generated_waiver_ids);


        $feeGeneratedList=GlobalSiteStudentFeeGenerate::where('site_id',$site_id)
            ->whereIn('id',$merged_fee_generate_id_splite)
            ->select('id','academic_fee_head_id','academic_fee_sub_head_id','site_student_fee_fine_allocation_id','amount')
            ->get();

        $waiverOfferHistory=GlobalSiteStudentFeeWaiverOfferHistory::whereIn('id',$merged_fee_generate_waiver_id_splite)
                ->select('id','student_fee_generated_id','academic_fee_sub_head_id','site_student_fee_fine_allocation_id','amount','percantage_status')
                ->get();

        $fee_head_ids=$feeGeneratedList->pluck('academic_fee_head_id')->unique()->values();
        $fee_sub_head_ids=$feeGeneratedList->pluck('academic_fee_sub_head_id')->unique()->values();

        $gatewaySetting=GlobalSiteStudentFeeGatewaySetting::where('fee_type_key','student_fee') 
            ->where('site_id',$site_id) 
            ->where('academic_group_id',$academic_group_id) 
            ->whereIn('academic_fee_head_id',$fee_head_ids)
            ->whereIn('academic_fee_sub_head_id',$fee_sub_head_ids)
            ->where('academic_payment_method_key','sonali_pay')
            ->where('status',true)
            ->select('id','site_payment_gateway_id','academic_fee_head_id','academic_fee_sub_head_id')
            ->get();


        $site_gateway_sett_ids=$gatewaySetting->pluck('site_payment_gateway_id')->unique()->values(); 

        $paymentGatewayList = GlobalSitePaymentGateway::with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType',
            'academicFeeType'])
          //  ->whereIn('id',$site_gateway_sett_ids)
            ->where('academic_payment_method_key','sonali_pay')
            ->where('status',true)
            ->select('id','site_id','academic_payment_method_key','partner_number','user_name')
            ->get();


            $credit_array=[];
            $key=0;
            foreach($paymentGatewayList as $gateway){

                $fineSetting=GlobalSiteStudentFeeGatewaySetting::where('fee_type_key','student_fee_fine') 
                    ->where('site_id',$site_id) 
                    ->where('academic_group_id',$academic_group_id) 
                    ->where('site_payment_gateway_id',$gateway->id) 
                    ->where('academic_payment_method_key','sonali_pay')
                    ->where('fine_amount_push_status',true)
                    ->where('status',true)
                  //  ->select('id','site_payment_gateway_id')
                    ->first();

                    $fine_add=0;

                //    dd($gatewayFineSetting);


                $site_gateway_sett=$gatewaySetting->where('site_payment_gateway_id',$gateway->id);
                   
                $academic_fee_head_ids=$site_gateway_sett->pluck('academic_fee_head_id')->unique()->values();
                $academic_fee_sub_head_ids=$site_gateway_sett->pluck('academic_fee_sub_head_id')->unique()->values();
                

                $feeGenerated=$feeGeneratedList
                        ->whereIn('academic_fee_head_id',$academic_fee_head_ids)
                        ->whereIn('academic_fee_sub_head_id',$academic_fee_sub_head_ids);
            
                if(count($feeGenerated)){

                $site_student_fee_fine_allocation_ids=$feeGenerated->pluck('site_student_fee_fine_allocation_id')->unique()->values();


                $fee_generated_ids=$feeGenerated->pluck('id');

                $waiver_list=$waiverOfferHistory->whereIn('academic_fee_sub_head_id',$academic_fee_sub_head_ids)
                    ->whereIn('site_student_fee_fine_allocation_id',$site_student_fee_fine_allocation_ids)
                    ->whereIn('student_fee_generated_id',$fee_generated_ids);

                $waiver_amount=0;
                if(count($waiver_list)>0){
                    
                    foreach($waiver_list as $keys=>$waiver){

                        $fee=GlobalSiteStudentFeeGenerate::where('id',$waiver->student_fee_generated_id)->first();
                        if($waiver->percantage_status){
                            $amount=($fee->amount*$waiver->amount)/100;
                        }else{
                            $amount=$waiver->amount;
                        }
                        $waiver_amount+=$amount;
                    }

                }


                 //=====fine distribution=======

          
                $fee_generated_amount=$feeGenerated->sum('amount');
             

                $total_fine_amount=0;
                if($fineSetting){
                    $fine_add=1;

                 //   dd($gatewayFineSetting);
                    $total_fine_amount=$this->getTotalPayableFineAmount($demand_slip_details);
                }

                $total_generated_amount=$fee_generated_amount+$total_fine_amount;


                $total_payable_amount=($total_generated_amount)-$waiver_amount;

                if($total_payable_amount>0){
                    $credit_array[$key]['site_gateway_id']=$gateway->id;
                    $credit_array[$key]['gateway_account_no']=$gateway->partner_number;
                    $credit_array[$key]['user_name']=$gateway->user_name;
                    $credit_array[$key]['amount']= $total_generated_amount;
                    $credit_array[$key]['waiver_amount']= $waiver_amount;
                    $credit_array[$key]['total_payable_amount']= $total_payable_amount;
                    $key++;
                }
             

            }

          //  dd($gatewayFineSetting);

              if($fineSetting && $fine_add==0){
             //   dd($fineSetting);
                    $total_fine_amount=$this->getTotalPayableFineAmount($demand_slip_details);

                    if($total_fine_amount>0){
                        $credit_array[$key]['site_gateway_id']=$gateway->id;
                        $credit_array[$key]['gateway_account_no']=$gateway->partner_number;
                        $credit_array[$key]['user_name']=$gateway->user_name;
                        $credit_array[$key]['amount']= (float) $total_fine_amount;
                        $credit_array[$key]['waiver_amount']= (float) '0';
                        $credit_array[$key]['total_payable_amount']=(float) $total_fine_amount;
                        $key++;
                    }

                  
                }

          


        }

        return $credit_array;

    }


  


    public function studentFeeInfoForSonaliPay($request_data){

       // dd('sf');

        $site_id=$request_data['site_id'];
        $request_amount=$request_data['request_amount'];
        $user_id=$request_data['user_id'];
        $redirect_path=$request_data['redirect_path'];
        $username= (string) $request_data['username'];

         // session check
         $currentTime = Carbon::now('Asia/Dhaka');
         $session=PaymentSession::where('user_id',$user_id)
             ->where('end_date_time','>',$currentTime)
             ->where('status',1)
             ->orderBy('id','DESC')
             ->first();
 
         if($session){
            $endTime = Carbon::parse($session->end_date_time); // Convert to Carbon
            $remainingTime = $currentTime->diffInSeconds($endTime);
            
            $response=[
                 'Status'=>'403',
                 'Message'=>'Your transaction process is running',
                 'Time'=>$remainingTime,
             ];

             return $response;
         }
   
        $payment_gateway = GlobalSitePaymentGateway::where('academic_payment_method_key', 'sonali_pay')
                    ->where('site_id',$site_id)
                    ->where('status',true)
                  //  ->where('academic_group_id',$academic_group_id)
                    ->first();

        if(!$payment_gateway){
            return ['Status'=>'410','Message'=>'Payment gateway not found!'];
        }
    
        $studentHistoryIDList=GlobalStudentHistory::where('user_id',$user_id)->where('status',true)->pluck('id');

        // $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
        //     ->where('site_id',$site_id)
        //  //   ->where('academic_group_id',$academic_group_id)
        //     ->where('status',1)
        //     ->orderBy('id', 'desc')
        //     ->first();

        $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
            $query->whereIn('student_history_id', $studentHistoryIDList)
                ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
            })
            ->where('status', 1)
            ->where('site_id', $site_id)
            ->orderBy('id', 'desc')
            ->first();
      
            
            if(!$demand_slip_details){
                return ['Status'=>'987','Message'=>'Slip Not found'];
            }


            $fee_details=$this->getGatewayStudentFeeDetails($site_id,$demand_slip_details);

           // dd($fee_details);

            // check request amount and payment amount
         //   dd($fee_details);
            if($fee_details['total_amount']!=$fee_details['generated_tot_fee']){
                return ['Status'=>'410','Message'=>'Request amount not match!, Please contact with admin'];
            }

             // check previous payment in there subheads
            $check_payment_happend = GlobalSiteStudentHeadWiseFeePaymentHistory::whereIn('student_fee_generate_id',$fee_details['fee_generate_id_array'])
                ->where('student_history_id', $demand_slip_details->student_history_id)
                ->where('pay_amount','>',0)
                ->get();

            if(count($check_payment_happend)){
                return ['Status'=>'410','Message'=>'This payment can only be made manually at the institute!'];
            }
         
            //====================sonali_pay==================
     
            $site_id= $demand_slip_details->site_id;
            $academic_group_id= $demand_slip_details->academic_group_id;
            
            $slip_id= $demand_slip_details->id;
            $invoiceNo= (string) $demand_slip_details->slip_no;
            $created_date= (string) $demand_slip_details->created_date;
            $total_amount= $fee_details['total_amount'];
            $student_full_name= (string) $demand_slip_details->studentHistory->full_name;
            $contact_number= (string) $demand_slip_details->studentHistory->student->contact_number;
            $address= (string) $demand_slip_details->studentHistory->student->address?$demand_slip_details->studentHistory->student->address:'';
            $email= (string) $demand_slip_details->studentHistory->student->email?$demand_slip_details->studentHistory->student->email:'';

            $partner_number= (string) $payment_gateway->partner_number;
            $user_name= (string) $payment_gateway->user_name;

            $student_name_lag=$this->detectMixedLanguage($student_full_name);

            if(empty($contact_number)){
                return ['Status'=>'410','Message'=>'Sorry! Make sure your contact number!'];
            }
            if($student_name_lag!='english'){
                return ['Status'=>'410','Message'=>'Sorry! Make sure your name is written in English.'];
            }

            // full domain url
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
            $domainName = $_SERVER['HTTP_HOST'];
            $fullDomainUrl = $protocol . $domainName;

            //===gateway wise amount pertition=====

         
            // check missing settings
            $checkGatewaySett=$this->checkGatewaySubheadSettings($demand_slip_details);

            if(!$checkGatewaySett){
                return ['Status'=>'410','Message'=>'Payment gateway settings not found!'];
            }
            // make array for credit
            $credit_array=$this->gatewayAccountWiseAmount($demand_slip_details);

         //   dd($credit_array);

            if(count($credit_array)){
                $credit_amount=collect($credit_array)->sum('total_payable_amount');
                $total_waiver_amount=collect($credit_array)->sum('waiver_amount');
                $total_payable_amount=$total_amount;

               // dd($credit_array,$total_payable_amount,$credit_amount,'f');

                if($total_payable_amount!=$credit_amount){
                    return ['Status'=>'410','Message'=>'Credit amount and fee amount not match!'];
                }

            }

            if(count($credit_array)){
               
                $serial_no=1;
                $total_cr_amount=0;
                $CreditInformations=[];
                foreach($credit_array as $key=>$credit){
                 
                    $credit_amount = (float) number_format($credit['total_payable_amount'], 2, '.', '');
                    $CreditInformations[$key]['SerialNo']=$serial_no;
                    $CreditInformations[$key]['CrAccountOrChallanNo']=$credit['gateway_account_no'];
                    $CreditInformations[$key]['CrAmount']=$credit_amount;
                    $CreditInformations[$key]['TranMode']="TRN";
                    $CreditInformations[$key]['Onbehalf']=$credit['user_name'];
    
                    $serial_no++;
                    $total_cr_amount+=$credit_amount;
                }
            }else{
                $CreditInformations=[
                    [
                    "SerialNo" => 1,
                    "CrAccountOrChallanNo" => $partner_number,
                    "CrAmount" => $total_amount,
                    "TranMode" => "TRN",
                    "Onbehalf" => $user_name
                    ]
                ];

                $total_cr_amount=$total_amount;
            }

            if($request_amount!=$total_cr_amount){
                return ['Status'=>'410','Message'=>'Credit amount not match!'];
            }

         //   $CreditInformations = json_encode($CreditInformations, JSON_PRETTY_PRINT);
    
 
            $trans_data = [
                "InvoiceNo" => $invoiceNo,
                "InvoiceDate" => $created_date,
                "RequestTotalAmount" => $total_cr_amount,
                "CustomerName" => $student_full_name,
                "CustomerContactNo" => $contact_number,
                "CustomerAddress" => $address,
                "Email" => $email,
                "ResponseUrl" => $fullDomainUrl.$redirect_path,
                "AllowDuplicateInvoiceNoDate" => "N",
                "CreditInformations" => $CreditInformations
            //     "CreditInformations" => [
            //         [
            //             "SerialNo" => 1,
            //             "CrAccountOrChallanNo" => $partner_number,
            //             "CrAmount" => $total_amount,
            //             "TranMode" => "TRN",
            //             "Onbehalf" => $user_name
            //         ],
            //         [
            //             "SerialNo" => 2,
            //             "CrAccountOrChallanNo" => "0002601020871",
            //             "CrAmount" => 10000.00,
            //             "TranMode" => "TRN",
            //             "Onbehalf" => "Rohim Company"
            //         ]
            //    ]
            ];

         //   dd($trans_data);
  
           $res_data=$this->siteStudentSonaliPayTransactionRequest('site-student',$trans_data,$request_data);

         
          
           if(!isset($res_data['Status'])){
                return ['Status'=>'410','Message'=>$res_data['Message']];
           }

            if($res_data['Status']==='200'){

                //session store
             
                $session=new PaymentSession();
                $session->user_id=$user_id;
                $session->slip_id=$slip_id;
                $session->start_date_time=Carbon::now('Asia/Dhaka');
                $session->end_date_time=Carbon::now('Asia/Dhaka')->addMinutes(11);
                $session->gateway_key='SonaliPay';
                $session->token=$res_data['Token'];
                $session->ip_address=request()->ip();
                $session->status=1;
                $session->site_id=$site_id;
                $session->save();
                //=====

                GlobalSiteStudentFeeDemandSlipDetails::where('id',$slip_id)
                    ->update([
                        'site_payment_gateway_id'=>$payment_gateway->id,
                        'transaction_token'=>$res_data['Token'],
                        'credit_info'=>json_encode($credit_array)
                    ]);

                return $res_data;
            }else{

                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-getinfo-error:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$res_data['Message'];
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();

                return ['Status'=>'410','Message'=>$res_data['Message']];
            }


    }


    public function feePaymentAndSonaliPayTokenVerify($data,$req_data){

        $site_id=$req_data['site_id'];
    //    $academic_group_id=$req_data['academic_group_id'];
        $username=$req_data['username'];
        $user_id=$req_data['user_id'];
        Session::put('SITE_ID',$site_id);

  
        $std_history_ids=GlobalStudentHistory::where('user_id',$user_id)->pluck('id');

        $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::where('site_id',$site_id)
        //    ->where('academic_group_id',$academic_group_id)
            ->where('transaction_token',$data['Token'])
            ->whereIn('student_history_id',$std_history_ids)
            ->orderBy('id', 'desc')
            ->where('status',1)
            ->first();

        //  dd($demand_slip_details);
           
            if(!$demand_slip_details){

             $request_text=json_encode($data);

                $res_data= [
                    'Status'=>'408',
                    'Message'=>'Mode Succcess, Token is not match',
                    'Details'=>$request_text
                ];

                $response_test=json_encode($res_data);

                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$response_test;
                $issue->site_id=$req_data['site_id'];
                $issue->username=$req_data['username'];
                $issue->ip_address=request()->ip();
                $issue->save();

                return $res_data;
            }

            $academic_group_id=$demand_slip_details->academic_group_id;

            $token = (string) $demand_slip_details->transaction_token;

            $req_data=[
                'Token'=>$token,
                'site_id'=>$site_id,
                'username'=>$username,
            ];


            $api_response=$this->verifyTransectionSonaliPayToken('site-student',$req_data);

          //  dd($api_response);
       
            if($api_response['Status']!='200'){
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$api_response['Message'];
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();

                return $api_response;
            }

           
            $slip_no = $demand_slip_details->id+100000;

        
            if($api_response['InvoiceNo']==$slip_no && $api_response['Token']===$token && $api_response['Status']==='200'){
               
                $res_data=[
                    'site_id'=>$site_id,
                    'academic_group_id'=>$academic_group_id,
                    'username'=>$username,
                    'user_id'=>$user_id,
                    'voucher_no'=>$api_response['InvoiceNo'],
                    'token'=>$api_response['Token'],
                    'status'=>$api_response['Status'],
                    'paid_amount'=>$api_response['RequestTotalAmount'],
                    'transaction_date'=>$api_response['TransactionDate'],
                    'transaction_amount'=>$api_response['CustomerPaidAmount'],
                    'transaction_id'=>$api_response['TransactionId'],
                    'sonali_pay_mode'=>$api_response['PayMode'],
                    'paid_by'=>'SonaliPay',
                    'bank_name'=>'SBL',
                ];

                // first update in slip
                $demand_slip_details->transaction_id=$api_response['TransactionId'];
                $demand_slip_details->save();

               $receive_res=$this->gatewayStudentPaymentReceive($res_data,$api_response,$demand_slip_details,'sonali_pay');

                if($receive_res['status']=='200'){
                    $issue = new IssueDetail();
                    $issue->issue_type='online-transaction-success:site-student';
                    $issue->issuer_type='site';
                    $issue->issue_details='payment receive successfully!';
                    $issue->site_id=$site_id;
                    $issue->username=$username;
                    $issue->ip_address=request()->ip();
                    $issue->save();
                }else{
                    $issue = new IssueDetail();
                    $issue->issue_type='online-transaction-receive-error:site-student';
                    $issue->issuer_type='site';
                    $issue->issue_details=$receive_res['message'];
                    $issue->site_id=$site_id;
                    $issue->username=$username;
                    $issue->ip_address=request()->ip();
                    $issue->save();
                }

                return $api_response;

            }else{
                $response_text=json_encode($api_response);

                $res_data= [
                    'Status'=>'409',
                    'Details'=>'Invoice, Token or Status not match',
                    'Message'=>$response_text
                ];

                $res_text=json_encode($res_data);

                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$res_text;
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();


                return $res_data;
            }

          

        
    }

    public function checkBySonaliPayTransactionIDAndGetInfoForWeb($data,$user){

        $student_history_ids=GlobalStudentHistory::where('user_id',$data['user_id'])->pluck('id');

        $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::where('transaction_id',$data['transaction_id'])
                    ->whereIn('student_history_id', $student_history_ids)
                    ->first();

        if(!$demand_slip_details){
            return ['status'=>'410','message'=>'Payment details not found!'];
        }
        $username=$data['username'];
        $user_id=$data['user_id'];
        $site_id=$demand_slip_details->site_id;
        $academic_group_id=$demand_slip_details->academic_group_id;

        $check_payment = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('student_history_id', $demand_slip_details->student_history_id)
            ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
            ->first();

        $prev_paymnet_list = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('id','!=',$check_payment->id)
            ->whereIn('student_history_id', $student_history_ids)
            ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
            ->get();


        return $this->paymentDetails($demand_slip_details,$check_payment,$prev_paymnet_list);

           
    
        }



    public function checkBySonaliPayTransactionID($data){

   //     dd($req_data);

//    'Username' => 'required',
//    'Password' => 'required',
//    'InvoiceNo' => 'required',
//    'InvoiceDate' => 'required',
//    'TransactionId' => 'required',

        $site_id=Session::get('SITE_ID');
        $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
        $username = Auth::user()->username;
        $user_id = Auth::user()->id;

            
        $student_history_ids=GlobalStudentHistory::where('user_id',$data['user_id'])->pluck('id');
    
        $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::where('transaction_id',$data['transaction_id'])
                    ->whereIn('student_history_id', $student_history_ids)
                    ->first();

        if(!$demand_slip_details){
            return response()->json(['status'=>'200','message'=>'Payment details not found!'],410);
            
        }

         $token = (string) $demand_slip_details->transaction_token;

         $req_data=[
             'Token'=>$token,
             'site_id'=>$data['site_id'],
             'academic_group_id'=>$academic_group_id,
             'username'=>$data['username'],
         ];

         $api_response=$this->verifyTransectionSonaliPayToken('site-student',$req_data);
        // $response_text=json_encode($api_response);

     //   dd($api_response);

        if($api_response['Status']!='200'){
            return response()->json(['status'=>'410','message'=>'Transaction ID not found!'],410);
        }

        $slip_no=$demand_slip_details->id+100000;

        if($api_response['InvoiceNo']!=$slip_no){
            return response()->json(['status'=>'410','message'=>'Transaction not match!'],410);
        }


        $site_id=$data['site_id'];
        $academic_group_id=$data['academic_group_id'];
        $username=$data['username'];
        $user_id=$data['user_id'];

        $para_data=[
            'site_id'=>$site_id,
            'academic_group_id'=>$academic_group_id,
            'username'=>$username,
            'user_id'=>$user_id,
            'voucher_no'=>$api_response['InvoiceNo'],
            'token'=>$api_response['Token'],
            'status'=>$api_response['Status'],
            'paid_amount'=>$api_response['RequestTotalAmount'],
            'transaction_date'=>$api_response['TransactionDate'],
            'transaction_amount'=>$api_response['CustomerPaidAmount'],
            'transaction_id'=>$api_response['TransactionId'],
            'sonali_pay_mode'=>$api_response['PayMode'],
            'paid_by'=>'SonaliPay',
            'bank_name'=>'SBL',
        ];

   
       $data= $this->paymentUpdateAndGetDetails($para_data,$student_history_ids,$demand_slip_details,$api_response);

       return $data;

    }

    public function updateSoanliPayment($data){

        $slip_id=$data['InvoiceNo']-100000;

        $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::where('created_date',$data['InvoiceDate'])
               // ->where('transaction_token',$data['Token'])
                ->where('id', $slip_id)
                ->first();
               
        if(!$demand_slip_details){
            return ['message'=>'Information not match!', 'status'=>'410'];
        }

        $student_history=GlobalStudentHistory::where('id',$demand_slip_details->student_history_id)->first();

        if(!$student_history){
            return ['message'=>'Student information not match!', 'status'=>'410'];
        }

        $user=GlobalUser::where('id',$student_history->user_id)->first();
       
       // $student_history_ids=[$demand_slip_details->student_history_id];
        $site_id=$demand_slip_details->site_id;
        $academic_group_id=$demand_slip_details->academic_group_id;
        $user_id=$user->id;
        $username=$user->username;
        $token=$data['Token'];

        $check_payment = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('student_history_id', $demand_slip_details->student_history_id)
            ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
            ->where('transaction_id', $data['TransactionId'])
            ->where('voucher_no', $data['InvoiceNo'])
            ->first();

          
        if($check_payment){
            return ['status'=>'200','message'=>'success'];
        }

    
        $req_data=[
            'Token'=>$data['Token'],
            'site_id'=>$site_id,
            'academic_group_id'=>$academic_group_id,
            'username'=>$username,
        ];


        $api_response=$this->verifyTransectionSonaliPayToken('site-student',$req_data);

        if($api_response['Status']!='200'){
            $issue = new IssueDetail();
            $issue->issue_type='online-transaction-failed:site-student';
            $issue->issuer_type='site';
            $issue->issue_details=$api_response['Message'];
            $issue->site_id=$site_id;
            $issue->username=$username;
            $issue->ip_address=request()->ip();
            $issue->save();

            return ['message'=>'API error!', 'status'=>'410'];
            
        }

           
        $api_slip_id = $api_response['InvoiceNo']-100000;

    
        if($api_slip_id==$slip_id && $api_response['TransactionId']===$data['TransactionId'] && $api_response['Token']===$token && $api_response['Status']==='200'){
            
            $res_data=[
                'site_id'=>$site_id,
                'academic_group_id'=>$academic_group_id,
                'username'=>$username,
                'user_id'=>$user_id,
                'voucher_no'=>$api_response['InvoiceNo'],
                'token'=>$api_response['Token'],
                'status'=>$api_response['Status'],
                'paid_amount'=>$api_response['RequestTotalAmount'],
                'transaction_date'=>$api_response['TransactionDate'],
                'transaction_amount'=>$api_response['CustomerPaidAmount'],
                'transaction_id'=>$api_response['TransactionId'],
                'sonali_pay_mode'=>$api_response['PayMode'],
                'paid_by'=>'SonaliPay',
                'bank_name'=>'SBL',
            ];

            
            $receive_res=$this->gatewayStudentPaymentReceive($res_data,$api_response,$demand_slip_details,'sonali_pay');

            if($receive_res['status']=='200'){
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-success:site-student';
                $issue->issuer_type='site';
                $issue->issue_details='payment receive successfully!';
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();

                //  return ['message'=>'success', 'status'=>'200'];

            }else{
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-receive-error:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$receive_res['message'];
                $issue->site_id=$site_id;
                $issue->username=$username;
                $issue->ip_address=request()->ip();
                $issue->save();

            }
            return $receive_res;


        }else{

            $issue = new IssueDetail();
            $issue->issue_type='online-transaction-failed:site-student';
            $issue->issuer_type='site';
            $issue->issue_details='Invoice, Token or Status not match';
            $issue->site_id=$site_id;
            $issue->username=$username;
            $issue->ip_address=request()->ip();
            $issue->save();
            return ['message'=>'Information not match!', 'status'=>'410'];
        }


    }


}
