<?php

namespace App\Traits\Site\Leave\Employee;

use App\Models\Event\Event;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\SiteEmployeeSiteShift;
use App\Models\Site\EmployeeDuty\SiteEmployeeDutyHistory;
use App\Models\Site\EmployeeLeave\SiteEmployeeLeaveHistory;
use App\Models\User\EmployeeHistory;
use Carbon\CarbonPeriod;
use Error;
use Exception;

trait LeaveFunction
{


    private function getEmployeeInLeave($employeeID, $search_date)
    {

        $employee_history = EmployeeHistory::where('user_id', $employeeID)
            ->where('status', 1)
            ->orderBy('id', 'DESC')
            ->first();

        $leave_history = SiteEmployeeLeaveHistory::where('employee_history_id', $employee_history->id)
            ->where('status', 1)
            ->where('leave_status', 'approved')
            ->get();

        if (count($leave_history)) {
            foreach ($leave_history as $key => $value) {
                $start_date = $value->from_date;
                $end_date = $value->to_date;

                $period = CarbonPeriod::create($start_date, $end_date);
                foreach ($period as $date) {
                    $dd = $date->format('Y-m-d');
                    if ($dd == $search_date) {
                        return true;
                    }
                }

            }
            return false;
        }

    }

    private function isTheDateOpen($search_date)
    {

        $event = Event::where('start_date', '<=', $search_date)
            ->where('end_date', '>=', $search_date)
            ->where('status', 1)
            ->first();

      //  dd($search_date);
        if (!$event) {
            return true;
        }
        return false;


    }




    private function getShiftBaseEmployeeInLeave($academic_group_id, $shift_id, $search_date)
    {

        $site_id = (int)session()->get('SITE_ID');

        $employee_academic_group_academic_shift_details = SiteEmployeeSiteShift::where('academic_group_id', $academic_group_id)
            ->where('academic_shift_id', $shift_id)
            ->where('site_id', $site_id)
            ->get();

        if ($employee_academic_group_academic_shift_details) {
            $user_ids = array();
            foreach ($employee_academic_group_academic_shift_details as $key => $value) {
                $employee_history_id = EmployeeHistory::where('user_id', $value->user_id)->where('status', 1)->pluck('id');

                $single_emp_leave_details = SiteEmployeeLeaveHistory::where('employee_history_id', $employee_history_id)
                    ->where('leave_status', 'approved')
                    ->orderBy('id', 'DESC')
                    ->first();

                if ($single_emp_leave_details) {

                    $start_date = $single_emp_leave_details->from_date;
                    $end_date = $single_emp_leave_details->to_date;

                    $period = CarbonPeriod::create($start_date, $end_date);
                    foreach ($period as $date) {
                        $dd = $date->format('Y-m-d');
                        if ($dd == $search_date) {

                            $user_ids[] = $value->user_id;

                        }
                    }

                }

            }

            return $user_ids;

        }


    }

    private function getTotalLeaveByDay($date, $shift_id, $employee)
    {
        $emp_ids = $employee->pluck('id');

        $emp_history_ids = EmployeeHistory::whereIn('user_id', $emp_ids)->pluck('id');

        $emp_leave_details = SiteEmployeeLeaveHistory::whereIn('employee_history_id', $emp_history_ids)->where('leave_status', 'approved')->get();
        $leave_days = 0;
        if (count($emp_leave_details)) {

            foreach ($emp_leave_details as $key => $value) {
                $start_date = $value->from_date;
                $end_date = $value->to_date;

                $period = CarbonPeriod::create($start_date, $end_date);
                foreach ($period as $apply_date) {
                    $dd = $apply_date->format('Y-m-d');
                    if ($dd == $date) {

                        $leave_days += 1;

                    }
                }

            }

        }
        return $leave_days;

    }


}
