<?php

namespace App\Traits\Site\Payment;


use App\Http\Middleware\EncryptCookies;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Student\GlobalStudentHistory;
use Carbon\Carbon;
use phpseclib\Crypt\RSA;
use Request;
use Illuminate\Support\Facades\File;

trait StudentBkashTransactionTrait
{
    use PaymentGatewayTrait;

    public function token()
    {
        session_start();


        $request_token = $this->bkash_Get_Token();
//        return $request_token;
//        dd($request_token);
        $idtoken=$request_token['id_token'];

        $_SESSION['token']=$idtoken;
//        $strJsonFileContents = file_get_contents("config.json");
//        $array = json_decode($strJsonFileContents, true);
        //=================testing===========
        $array = PaymentGateway::where('academic_payment_method_key', 'bkash')
            ->whereHas('academicOnlinePaymentMarchentType', function ($q)  {
                return $q->where('name_key', '=', 'e_commerce');
            })
            ->first();
        if($array){
            $array->update([
                'token'=>$idtoken
            ]);
        }
        //===============================

//        $array = $this->getConfigFile();
//        $array['token']=$idtoken;
//
//        $newJsonString = json_encode($array);
//        file_put_contents('config.json',$newJsonString);
//        File::put(storage_path().'/app/public/config.json',$newJsonString);

        echo $idtoken;
    }

    protected function bkash_Get_Token(){

//        $strJsonFileContents = file_get_contents("config.json");
//        $array = json_decode($strJsonFileContents, true);

        //============database test=============
        $array = PaymentGateway::where('academic_payment_method_key', 'bkash')
            ->whereHas('academicOnlinePaymentMarchentType', function ($q)  {
                return $q->where('name_key', '=', 'e_commerce');
            })
            ->first();

        $post_token=array(
            'app_key'=>$array->app_key,
            'app_secret'=>$array->app_secret
        );

        $url=curl_init($array->token_url);
//        return $array->token_url;
        $proxy = $array->proxy;
        $posttoken=json_encode($post_token);


        $header=array(
            'Content-Type:application/json',
            'password:'.$array->password,
            'username:'.$array->user_name
        );
//        return $header;

       //==========file test=============

//        $array = $this->getConfigFile();
//
////        return $array;
//
//        $post_token=array(
//            'app_key'=>$array["app_key"],
//            'app_secret'=>$array["app_secret"]
//        );
//
//
////        return $post_token;
////        return $array["tokenURL"];
//        $url=curl_init($array["tokenURL"]);
//
//        $proxy = $array["proxy"];
//        $posttoken=json_encode($post_token);
//
//        $header=array(
//            'Content-Type:application/json',
//            'password:'.$array["password"],
//            'username:'.$array["username"]
//        );
////        return $header;
//


        curl_setopt($url,CURLOPT_HTTPHEADER, $header);
        curl_setopt($url,CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url,CURLOPT_POSTFIELDS, $posttoken);
        curl_setopt($url,CURLOPT_FOLLOWLOCATION, 1);
        //curl_setopt($url, CURLOPT_PROXY, $proxy);

        $resultdata=curl_exec($url);
        curl_close($url);
//        return $resultdata;

        return json_decode($resultdata, true);
//        return $resultdata;
    }

    public function getConfigFile()
    {
        $path = storage_path()."/app/public/config.json";
        return json_decode(file_get_contents($path),true);
    }
    public function createPayment()
    {
      
        session_start();
//        $strJsonFileContents = file_get_contents("config.json");
//        $array = json_decode($strJsonFileContents, true);
        $array = PaymentGateway::where('academic_payment_method_key', 'bkash')
            ->whereHas('academicOnlinePaymentMarchentType', function ($q)  {
                return $q->where('name_key', '=', 'e_commerce');
            })
            ->first();
           // dd($array);
        $amount = $_GET['amount'];
        $invoice = $_GET['invoice']; // must be unique
        $intent = "sale";
        $proxy = $array->proxy;
        $createpaybody=array('amount'=>$amount, 'currency'=>'BDT', 'merchantInvoiceNumber'=>$invoice,'intent'=>$intent);
        $url = curl_init($array->create_url);

        $createpaybodyx = json_encode($createpaybody);

        $header=array(
            'Content-Type:application/json',
            'authorization:'.$array->token,
            'x-app-key:'.$array->app_key
        );



//        $array = $this->getConfigFile();
//        $amount = $_GET['amount'];
//        $invoice = $_GET['invoice']; // must be unique
//        $intent = "sale";
//        $proxy = $array["proxy"];
//        $createpaybody=array('amount'=>$amount, 'currency'=>'BDT', 'merchantInvoiceNumber'=>$invoice,'intent'=>$intent);
//        $url = curl_init($array["createURL"]);
//
//        $createpaybodyx = json_encode($createpaybody);
//
//        $header=array(
//            'Content-Type:application/json',
//            'authorization:'.$array["token"],
//            'x-app-key:'.$array["app_key"]
//        );

        curl_setopt($url,CURLOPT_HTTPHEADER, $header);
        curl_setopt($url,CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url,CURLOPT_POSTFIELDS, $createpaybodyx);
        curl_setopt($url,CURLOPT_FOLLOWLOCATION, 1);
        //curl_setopt($url, CURLOPT_PROXY, $proxy);

        $resultdata = curl_exec($url);
        curl_close($url);
        
        echo $resultdata;

    }
    public function executePayment($data)
    {
        session_start();
//        $strJsonFileContents = file_get_contents("config.json");
//        $array = json_decode($strJsonFileContents, true);
        $array = PaymentGateway::where('academic_payment_method_key', 'bkash')
            ->whereHas('academicOnlinePaymentMarchentType', function ($q)  {
                return $q->where('name_key', '=', 'e_commerce');
            })
            ->first();

        $paymentID = $_GET['paymentID'];
        $proxy = $array["proxy"];

        $url = curl_init($array->execute_url.$paymentID);

        $header=array(
            'Content-Type:application/json',
            'authorization:'.$array->token,
            'x-app-key:'.$array->app_key
        );


//        $array = $this->getConfigFile();
//        $paymentID = $_GET['paymentID'];
//        $proxy = $array["proxy"];
//
//        $url = curl_init($array["executeURL"].$paymentID);
//
//        $header=array(
//            'Content-Type:application/json',
//            'authorization:'.$array["token"],
//            'x-app-key:'.$array["app_key"]
//        );

        curl_setopt($url,CURLOPT_HTTPHEADER, $header);
        curl_setopt($url,CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($url,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($url,CURLOPT_FOLLOWLOCATION, 1);
//curl_setopt($url, CURLOPT_PROXY, $proxy);

        $resultdatax=curl_exec($url);
        curl_close($url);
        $this->updateOrderStatus($resultdatax, $array);
//        return $fg;
        echo $resultdatax;
    }
    protected function updateOrderStatus($resultdatax, $array)
    {
        $resultdatax = json_decode($resultdatax);

        if($resultdatax && $resultdatax->paymentID != null && $resultdatax->transactionStatus == 'Completed'){
            $trxID = $resultdatax->trxID;
            $paymentID = $resultdatax->paymentID;
            $createTime = $resultdatax->createTime;
            $transactionStatus = $resultdatax->transactionStatus;
            $amount = $resultdatax->amount;
            $currency = $resultdatax->currency;

            $merchantInvoiceNumber = $resultdatax->merchantInvoiceNumber;
            if($merchantInvoiceNumber){
                $payment_type = 'bkash';
                $transaction_by_id = false;
                $demand_slip_id = $merchantInvoiceNumber - 100000;
                $get_demand_slip=SiteStudentFeeDemandSlipDetails::where('id', $demand_slip_id)->first();
                $data = $this->getDemandSlipDetails($get_demand_slip);

                $return_data = [
                    'trx_id' => $trxID,
                    'payment_id' => $paymentID,
                    'created_time' => $createTime,
                    'transaction_status' => $transactionStatus,
                    'amount' => $amount,
                    'currency' => $currency,
                    'marchent_id' => $array->partner_code,
                ];

                $final_data = $this->paymentReceive($data, $return_data, $payment_type, $transaction_by_id);

                //=====Log Start

                $user_list=GlobalStudentHistory::with(['student'=>function($query){
                    $query->select('id', 'username');
                }])
                    ->select('id', 'user_id')
                    ->where('id', $get_demand_slip->student_history_id)
                    ->first();

                $return_data = json_encode($resultdatax, true);
                $issue = new    IssueDetail();
                $issue->issue_type = 'transaction:site-student';

                $issue->bearer_type = 'site';
                $issue->bearer_id = \Session::get('SITE_ID');
                $issue->username = $user_list->student->username;
                $issue->ip_address = request()->ip();
                $issue->issue_details = $return_data;

                $issue->save();

            }
            return true;
        }
    }

}