<?php

namespace App\Traits\Site\Payment;

use App\Jobs\site\GlobalPaymentHistoryJob;

use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;

use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use App\Models\Site\SiteInfo;
use App\Traits\SmsFunctionsTrait;
use App\Models\Edu\Issue\IssueDetail;
use Carbon\CarbonPeriod;
use App\Http\Middleware\EncryptCookies;
use Carbon\Carbon;
use Request;
use Response;
use Exception;
use DB;

trait StudentIbblTransactionTrait
{

    use SmsFunctionsTrait;

    private $eduUserForIbbl='ibblPaymentAccesszzz';
    private $eduPassForIbbl='theworld@eduWorld123456*#:;ctganis@gm';

    //====== get Applicant information for admission=======

    public function getApplicantAdmissionInfo($request){
        $edu_user_id=$this->eduUserForIbbl;
        $eud_pass=$this->eduPassForIbbl;

        $myPassword=$eud_pass.$request['random'].$request['referenceId'];

        $mypass= hash("sha512",$myPassword);
        $bankPass= $request['password']; // this actual password for server
      //  $bankPass= hash("sha512",$request['password'].$request['random'].$request['referenceId']); // for test

        
        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');
        $today_date =  $now->toDateString();

        if($edu_user_id===$request['userId'] && $mypass===$bankPass){
           
            $borad_approve_student=GlobalSiteStudentAdmissionBoardApprove::where('board_roll_number', $request['referenceId'])
                    ->where('status',1)
                    ->first();

            if($borad_approve_student){

                $invoiceNo=$borad_approve_student->id+100000;

                return Response::json(
                    [
                        'referenceId'=>$borad_approve_student->board_roll_number??'',
                        'dateTime' => $dateTime,
                        'responseCode' => '00',
                        'responseMsg' => 'SUCCESS',
                        'feeDetails' => [
                            'studentId'=>$borad_approve_student->board_roll_number??'',
                            'instituteName'=>$borad_approve_student->site?$borad_approve_student->site->site_name:'',
                            'branchName' => 'fatehabad',
                            'shift' => $borad_approve_student->shift?$borad_approve_student->shift->shift_name:'',
                            'className' => $borad_approve_student->stClass?$borad_approve_student->stClass->class_name:'',
                            'sectionName' => '',
                            'invoiceNo' => $invoiceNo,
                            'studentName' => $borad_approve_student->first_name?$borad_approve_student->first_name:'',
                            'fatherName' => $borad_approve_student->father_name?$borad_approve_student->father_name:'',
                            'month' => '',
                            'academicYear' => $borad_approve_student->year?$borad_approve_student->year->year_name:'',
                            'fee' => $borad_approve_student->admission_fee,
                            'waiver' => $borad_approve_student->waiver_fee,
                            'totalDue' => $borad_approve_student->admission_fee,
                         ],
                    ]
                    , 200);
            }else{
                return $this->failResponseFroGetStudentInfo($dateTime);
            }

        }else{
            return Response::json(['responseCode'=>'90','responseMsg'=>'Unauthorized'],401);
        }
    }


    //====== get Student information for existing student=======
   
    public function getStudentFeeInfo($request){
        
        $edu_user_id=$this->eduUserForIbbl;
        $eud_pass=$this->eduPassForIbbl;

        $myPassword=$eud_pass.$request['random'].$request['referenceId'];

        $mypass= hash("sha512",$myPassword);
        $bankPass= $request['password']; // this actual password for server
       // $bankPass= hash("sha512",$request['password'].$request['random'].$request['referenceId']); // for test

        
      
        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');
        $today_date =  $now->toDateString();

       if($edu_user_id===$request['userId'] && $mypass===$bankPass){
         
          $user=GlobalUser::where('username', $request['referenceId'])->select('id','site_id')->first();
          if($user){

             $student_details = GlobalStudentHistory::where('user_id',$user->id)
                ->where('site_id',$user->site_id)
                ->where('status',1)
                ->with(['site','student','year','shift','stClass','accGroup','section', 'department'])
                ->first();

              $site_id=$student_details->site_id;
              $academic_group_id=$student_details->academic_group_id;

             $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::where('student_history_id', $student_details->id)
                 ->where('site_id',$site_id)
                 ->where('academic_group_id',$academic_group_id)
                 ->where('status',1)
                 ->orderBy('id', 'desc')
                 ->first();


             if($demand_slip_details){
                        
                 $slip_id = $demand_slip_details->id;
              
                 $check_paymnet_happend = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
                        ->where('academic_group_id',$academic_group_id)
                        ->where('student_history_id', $demand_slip_details->student_history_id)
                        ->where('site_student_fee_demand_slip_details_id', $slip_id)
                        ->first();

                $studentFineList=GlobalSiteStudentFeeFine::where('site_id',$site_id)
                    ->where('academic_group_id',$academic_group_id)
                    ->get();
                     //  dd($studentFineList);

                     ///////////////

                     $previous_paid_amount = 0;
                        $payment_list_by_demand_slip = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
                        ->where('academic_group_id',$academic_group_id)
                        ->where('site_student_fee_demand_slip_details_id', $slip_id)->get();
                        if(count($payment_list_by_demand_slip)){
                            foreach ($payment_list_by_demand_slip as $kk => $vv){
                                $previous_paid_amount+= $vv->paid_amount;
                            }
                        }

                    //    dd($previous_paid_amount);

                     ///////////////
                    
                $fee_delay_fine = $this->feeDelayFine($demand_slip_details,$today_date);
                $due_fine = $this->feeDueFine($studentFineList,$demand_slip_details,$slip_id, $check_paymnet_happend);
                $extra_fine = $this->extraFine($studentFineList,$slip_id);

                $fee_due_fine=$due_fine[0];

                $total_fee_fine=$fee_due_fine+$fee_delay_fine+$extra_fine;

              //  dd($demand_slip_details);
          
                 $tot_waiver=$demand_slip_details->waiver_amount;
                 $tot_ms_amount =  $demand_slip_details->total_amount;
                 $total_amount_with_fine =  ($tot_ms_amount + $total_fee_fine)-$previous_paid_amount;
                 $total_amount_with_fine_waiver =   $total_amount_with_fine + $tot_waiver;

                 $total_due_amount = number_format((float)$total_amount_with_fine, 2, '.', '');
                 $total_amount = number_format((float)$total_amount_with_fine_waiver, 2, '.', '');
                 $total_waiver=number_format((float)$tot_waiver, 2, '.', '');

                 $invoiceNo= (string) $demand_slip_details->slip_no;

                  return Response::json(
                     [
                         'referenceId'=>$student_details->student?$student_details->student->username:'',
                         'dateTime' => $dateTime,
                         'responseCode' => '00',
                         'responseMsg' => 'SUCCESS',
                         'feeDetails' => [
                             'studentId'=>$student_details->student?$student_details->student->username:'',
                             'instituteName'=>$student_details->site?$student_details->site->site_name:'',
                             'branchName' => 'Chowdhuryhat',
                             'shift' => $student_details->shift?$student_details->shift->shift_name:'',
                             'className' => $student_details->stClass?$student_details->stClass->class_name:'',
                             'sectionName' => $student_details->section?$student_details->section->section_name:'',
                             'invoiceNo' => $invoiceNo??'',
                             'studentName' => $student_details->full_name?$student_details->full_name:'',
                             'fatherName' => $student_details->student?$student_details->student->father_name:'',
                             'month' => '',
                             'academicYear' => $student_details->year?$student_details->year->year_name:'',
                             'fee' => $total_amount,
                             'waiver' => $total_waiver,
                             'totalDue' => $total_due_amount,
                          ],
                     ]
                     , 200);

             }else{
                 return $this->failResponseFroGetStudentInfo($dateTime);
             }

          }else{
            return $this->failResponseFroGetStudentInfo($dateTime);
          }
    }else{
        return Response::json(['responseCode'=>'90','responseMsg'=>'Unauthorized'],401);
    }
}


private function failResponseFroGetStudentInfo ($dateTime){

    return Response::json(
        [
            'referenceId' => '',
            'dateTime' => $dateTime,
            'responseCode' => '90',
            'responseMsg' => 'Data not found',
            'feeDetails' => [
                'studentId'=>null,
                'instituteName'=>null,
                'branchName' => null,
                'shift' => null,
                'className' => null,
                'sectionName' => null,
                'invoiceNo' => null,
                'studentName' => null,
                'fatherName' => null,
                'month' => '',
                'academicYear' => null,
                'fee' => null,
                'waiver' => null,
                'totalDue' => null,
             ]
        ]
        , 411);
}

// Student Fee postion

public function postingPaymentInfoForNewAdmission($request){

    // $borad_approve_student_id=$request['invoiceNo']-100000;
  
    // $borad_approve_student=GlobalSiteStudentAdmissionBoardApprove::where('id',$borad_approve_student_id)
    //     ->where('status',1)
    //     ->first();

    // if($borad_approve_student){

    //    $borad_approve_student->transection_number=$request['trId'];
    //    $borad_approve_student->iid=$request['iid'];
    //    $borad_approve_student->admission_fee=$request['cr_amount'];
    //    $borad_approve_student->total_fee_with_other=$request['tr_amount'];
    //    $borad_approve_student->save();



    //     return Response::json(['responseCode'=>'00','responseMsg'=>'success'],200);

    // }else{
    //     return Response::json(['responseCode'=>'90','responseMsg'=>'Failed'],401);
    // }


    
    dd('sfsf');

}


public function postingPaymentInfoForStudent($request){


    $edu_user_id=$this->eduUserForIbbl;
    $eud_pass=$this->eduPassForIbbl;


    $payment_date = Carbon::createFromFormat('d/m/Y H:i A', $request['date_time'])->format('Y-m-d');
    $payment_time = Carbon::createFromFormat('d/m/Y H:i A', $request['date_time'])->format('H:i');
    $sendSmsStatus=0;
    $now = Carbon::now();
    $today_date =  $now->toDateString();

    $myPassword=$eud_pass.$request['trId'].$request['invoiceNo'];

    $mypass= hash("sha512",$myPassword);
    $bankPass= $request['password']; // this actual password for server
 //   $bankPass= hash("sha512",$request['password'].$request['trId'].$request['invoiceNo']); // for test

    if($edu_user_id===$request['userId'] && $mypass===$bankPass){

       if($request['status']==='APPROVED'){

       $slip_id=$request['invoiceNo']-100000;

       $demand_slip_details = GlobalSiteStudentFeeDemandSlipDetails::where('id', $slip_id)
                ->where('status',1)
                ->first();
              
       if($demand_slip_details){
        $studentHistory=GlobalStudentHistory::where('id',$demand_slip_details->student_history_id)
            ->with('student')
            ->first();
      
      
          $site_id=$studentHistory->site_id;
          $academic_group_id=$studentHistory->academic_group_id;

           //==============fine section===================
           $check_paymnet_happend = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
                ->where('academic_group_id',$academic_group_id)
                ->where('student_history_id', $demand_slip_details->student_history_id)
                ->where('site_student_fee_demand_slip_details_id', $slip_id)
                ->first();

           

           $studentFineList = GlobalSiteStudentFeeFine::where('site_id',$site_id)
                ->where('academic_group_id', $academic_group_id)
                ->get();
                //   dd($studentFineList);

            $fee_delay_fine = $this->feeDelayFine($demand_slip_details,$today_date);
            $due_fine = $this->feeDueFine($studentFineList,$demand_slip_details,$slip_id,$check_paymnet_happend);
            $extra_fine = $this->extraFine($studentFineList,$slip_id);

          
            $fee_due_fine=$due_fine[0];
            $site_std_fee_fine_id=$due_fine[1];

            // previous paid amount
            
            $previous_paid_amount = 0;
            $payment_list_by_demand_slip = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id',$academic_group_id)
            ->where('site_student_fee_demand_slip_details_id', $slip_id)->get();
            if(count($payment_list_by_demand_slip)){
                foreach ($payment_list_by_demand_slip as $kk => $vv){
                    $previous_paid_amount+= $vv->paid_amount;
                }
            }

            $total_fine=$fee_due_fine+$fee_delay_fine+$extra_fine;

           $total_amount=($demand_slip_details->total_amount+$total_fine)-$previous_paid_amount;


           if($request['cr_amount']==$total_amount){

            $check_payment = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
                    ->where('academic_group_id',$academic_group_id)
                    ->where('student_history_id', $demand_slip_details->student_history_id)
                    ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
                    ->get();
         

                if(count($check_payment)>0){
                        foreach ($check_payment as $kkk => $vvv){
                            
                        $vvv->update([
                            'status' => 0,
                        ]);
                        if($vvv->due_amount == 0){
                            // return Response::json(['message' => 'Sorry! This Payment Already Taken!'], 411);
                            return Response::json(['responseCode'=>'90','responseMsg'=>'Failed'],401);
                        }
                        }
                }else{
                        //------------------previous payment status change------------------------

                        $check_previous_payment_status = GlobalSiteStudentFeePaymentHistory::where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->where('student_history_id', $demand_slip_details->student_history_id)
                        ->where('status', 1)
                        ->get();

                        if(count($check_previous_payment_status)){
                        foreach ($check_previous_payment_status as $kkkk => $vvvv){
                            $vvvv->update([
                                    'status' => 0,
                            ]);
                        }

                        }
                }

               //=========================== new payment ===================================
            $student_payment_save = new GlobalSiteStudentFeePaymentHistory();
            $student_payment_save->site_id = $site_id;
            $student_payment_save->academic_group_id = $academic_group_id;
            $student_payment_save->payment_date = $payment_date;
            $student_payment_save->payment_time = $payment_time;
            $student_payment_save->site_student_fee_demand_slip_details_id = $demand_slip_details->id;
            $student_payment_save->student_history_id = $demand_slip_details->student_history_id;
            
            $student_payment_save->paid_amount = $request['cr_amount'];
            $student_payment_save->tr_amount = $request['tr_amount'];

            $student_payment_save->due_amount = 0;
            // $student_payment_save->created_by = 5;
            $student_payment_save->status = 1;
            $student_payment_save->paid_by = $request['source_of_fund'];
            $student_payment_save->bank_name = 'ibbl';
            $student_payment_save->transaction_id = $request['trId']; 
            $student_payment_save->iid = $request['iid']; 

            $student_payment_save->voucher_no = $request['invoiceNo'];
            
                if($student_payment_save->save()){
                    $demand_slip_details->status = 0;  
                    $demand_slip_details->save();
                }

                $last_payment_history_get = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
                    ->where('academic_group_id', $academic_group_id)
                    ->where('student_history_id', $demand_slip_details->student_history_id)
                    ->where('status', 1)
                    ->orderBy('id','DESC')
                    ->first();

                $fee_fine_generate = GlobalSiteStudentFeeFine::where('site_id',$site_id)
                    ->where('academic_group_id', $academic_group_id)
                    ->where('site_student_fee_demand_slip_details_id', $slip_id)
                    ->where('fee_type','delayfine')
                    ->first();
       
                if(!$fee_fine_generate){
                    if($fee_delay_fine>0){
                        $fee_fine_create = GlobalSiteStudentFeeFine::create([
                            'site_id' => $site_id,
                            'academic_group_id' => $academic_group_id,
                            'site_student_fee_demand_slip_details_id' => $slip_id,
                            'fine_amount' => $fee_delay_fine,
                            'status' => 0,
                            'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                            'student_history_id' => $demand_slip_details->student_history_id,
                            'fee_type' => 'delayfine',
                            'created_date' => $payment_date,
                        ]);
                    }
                }

                if($fee_due_fine>0){

                    $fee_fine_update = GlobalSiteStudentFeeFine::where('site_id',$site_id)
                        ->where('academic_group_id',$academic_group_id)
                        ->whereIn('id', $site_std_fee_fine_id)
                        ->where('site_student_fee_payment_history_id', "=", null)
                        ->get();

                    if(count($fee_fine_update)>0){
                        foreach ($fee_fine_update as $kke => $vvll){
                            $vvll->update([
                                'status' => 0,
                                'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                            ]);
                        }
                    }

                }


        //=========================sms================================
        $paymentHistoryDetails = GlobalSiteStudentFeePaymentHistory::where('site_id',$site_id)
            ->where('academic_group_id', $academic_group_id)
            ->where('student_history_id', $demand_slip_details->student_history_id)
            ->where('status', 1)
            ->with('globalStudentHistory')
            ->first();

            $the_site = SiteInfo::findOrFail($site_id);

            if($the_site->std_fee_paid_sms){
      
                $data_time=$paymentHistoryDetails->payment_date.' '.$paymentHistoryDetails->payment_time;

                $phone_number =  $studentHistory->student->contact_number;
                $student_name = $studentHistory->student->full_name;
                $paid_amount = $paymentHistoryDetails->paid_amount;
                $transaction_id = $paymentHistoryDetails->transaction_id;
                $due_amount = '0';
                $payment_date = $data_time;
               

                $sms_txt = "Payment Successful";
                $sms_txt .=', '.$student_name;
                $sms_txt .=', '.'Paid:'.$paid_amount;
                $sms_txt .=', '.'Due:'.$due_amount;
                $sms_txt .=', '.'TrxID :'.$transaction_id;
                $sms_txt .=', '.'Payment Date:'.$payment_date;
                $sms_txt .=', '.'Thanks:' . $the_site->site_name;

                $tt = $this->sendSms($site_id, [$phone_number] ,$sms_txt );
               // dd();
            }
            dispatch(new GlobalPaymentHistoryJob($paymentHistoryDetails));

       

            //======================notification========================

            DB::commit();
            
                return Response::json(['responseCode'=>'00','responseMsg'=>'success'],200);

            }else{
                return Response::json(['responseCode'=>'90','responseMsg'=>'Failed'],401);
            }
       }else{
          return Response::json(['responseCode'=>'90','responseMsg'=>'Failed'],401);
       }
    }else{
       return Response::json(['responseCode'=>'90','responseMsg'=>'Status Not Approve'],404);
    }

    }else{
       return Response::json(['responseCode'=>'90','responseMsg'=>'Unauthorized'],401);
    }
}


    private function feeDelayFine($demand_slip_details,$today_date){
        $fee_delay_fine = 0;

        if($demand_slip_details->payment_from_date){
            $start_date = $demand_slip_details->payment_from_date;
            $end_date = $demand_slip_details->payment_to_date;

            $period = CarbonPeriod::create($start_date, $end_date);

            $delay_fine_test = 1;
            $delay_fine = 0;

            foreach ($period as $date) {
                $formated_date =  $date->format('Y-m-d');
                if($formated_date == $today_date){
                    $delay_fine_test = 0;
                }
            }

            if($delay_fine_test==1){
                $delay_fine = $demand_slip_details->delay_fine;
            }else{
                $delay_fine = 0;
            }

            $fee_delay_fine = $delay_fine;
        }
        return $fee_delay_fine;

    }


    private function feeDueFine($studentFineList,$demand_slip_details,$slip_id, $check_paymnet_happend){

            //================due fine=======================
       
            if($check_paymnet_happend){
                $due_fine = $studentFineList
                        ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->previous_site_student_fee_demand_slip_detail_id)
                        ->where('fee_type', 'duefine');

                if(count($due_fine)>0){
                        $due_fine_check = $due_fine;
                }else{
                        $due_fine_check = $studentFineList
                            ->where('status', 1)
                            ->where('student_history_id', $demand_slip_details->student_history_id);
                }
            }else{
                $due_fine_check = $studentFineList
                    ->where('status', 1)
                    ->where('student_history_id', $demand_slip_details->student_history_id);
                  //  dd($studentFineList);
            }


            $site_std_fee_fine_id=[];
            $fee_due_fine=0;
            if(count($due_fine_check)){
            foreach ($due_fine_check as $key => $value){
                    $fee_due_fine+= $value->fine_amount;
                    $site_std_fee_fine_id[$key] = $value->id;
            }

            }else{
            $fee_due_fine = 0;
            }

            return [$fee_due_fine,$site_std_fee_fine_id];

    }

    private function extraFine($studentFineList,$slip_id){

        $check_extra_fine = $studentFineList
            ->where('site_student_fee_demand_slip_details_id',$slip_id)
            ->where('fee_type', 'extrafine');

        $extra_fine = 0;

        if(count($check_extra_fine)>0){
            foreach ($check_extra_fine as $kk => $vl){
                $extra_fine+=$vl->fine_amount;
            }
        }

        return $extra_fine;

    }


public function checkIbblPayment($request){

       

//     $ibblUserId='merchant.28201002';
//     $ibblPassword='286f88c6eec7ae4a0c0d6fbc90d2751947ffd3df49ddaed25ce3386ccb4f7f1a5
//     857f372ee9564d8f9aa216159909b8f7bed49742a3e4bc65753ca5d82c28da8';
//     $operation='STATUS';
//     $random='a28c6a6c-21e4-3c0d-a18b-43cee74ca787';
//     $invoiceNo='201025PAY10XAA';

//     $url = 'https://staging.islamicbankbd.com/schoolfee/getTrxInfo.do';
//     $url=curl_init($url);
//     curl_setopt($url,CURLOPT_HTTPHEADER, $header);
//     curl_setopt($url,CURLOPT_CUSTOMREQUEST, "POST");
//     curl_setopt($url,CURLOPT_RETURNTRANSFER, true);
//     curl_setopt($url,CURLOPT_POSTFIELDS, $posttoken);
//     curl_setopt($url,CURLOPT_FOLLOWLOCATION, 1);
//     //curl_setopt($url, CURLOPT_PROXY, $proxy);

//     $resultdata=curl_exec($url);
//     curl_close($url);
// //        return $resultdata;

//     return json_decode($resultdata, true);
    }

    public function sendSms($site_id, $numbers, $sms_txt)
    {

        try {
            $type='site';
            $this->sendSmsUsingQueue($numbers, $sms_txt, $type, $site_id);
            return true;

        } catch (Exception $exception) {
            $issue = new IssueDetail();
            $issue->issue_type = 'sms';
            $issue->issue_details = $exception->getMessage();
            $issue->site_id = $site_id;
            $issue->save();

            return false;

        }
    }



}