<?php

namespace App\Traits\Site\Payment;


use App\Http\Middleware\EncryptCookies;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Edu\PaymentGateway\EduPaymentGateway;
use App\Models\Edu\SitePayment\EduInvoicePayment;
use App\Models\Edu\SitePayment\SiteInvoice;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Traits\Invoice\InvoiceHistoryTrait;
use App\Traits\Site\Fee\StudentFeeTrait;
use Carbon\Carbon;
use phpseclib\Crypt\RSA;
use Request;
use Session;
use Response;
use Illuminate\Support\Facades\File;
use Auth;

trait StudentSonaliPayTransactionTrait
{
    private $eduUserForSonaliPay='EduWorldUser';
    private $eduPassForSonaliPay='EduUser1234';


    public function siteStudentSonaliPayTransactionRequest($fee_key,$trans_data,$request_data){

        $payment_gateway = GlobalSitePaymentGateway::where('academic_payment_method_key', 'sonali_pay')
            ->where('site_id',$request_data['site_id'])
        //    ->where('academic_group_id',$request_data['academic_group_id'])
            ->first();

        

            if(!$payment_gateway){
                return ['Status'=>'410','Message'=>'Payment gateway not found!'];
            }
            
          

       // api action 
            $host=$payment_gateway->create_url?$payment_gateway->create_url:'https://spg.com.bd:6314';
            $url = $host."/api/v3/spgservice/CreatePaymentRequest";

           // dd($url);
       
         //   $url = "https://spg.com.bd:6314/api/v3/spgservice/CreatePaymentRequest";
          //  $url = "https://spg.sblesheba.com:6314/api/v3/spgservice/CreatePaymentRequest"; // for test

            $headers = [
                "Authorization:".$payment_gateway->authorization,
                "Content-Type: application/json"
            ];
             // dd($trans_data);

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($trans_data));

            $response = curl_exec($ch);
        
            curl_close($ch);
            $res_data=json_decode($response,true);
            
         
            $issue = new IssueDetail();
            $issue->issue_type = 'online-transaction-start:'.$fee_key;
            $issue->issuer_type = 'site';
            $issue->issue_details = $response;
            $issue->site_id=$request_data['site_id'];
            $issue->username = $request_data['username'];
            $issue->ip_address =request()->ip();
            $issue->save();

         //   dd($response);

           return $res_data;

    }

    public function verifyTransectionSonaliPayToken($fee_key,$req_data){

        $payment_gateway = GlobalSitePaymentGateway::where('academic_payment_method_key', 'sonali_pay')
            ->where('site_id',$req_data['site_id'])
            ->first();

        if(!$payment_gateway){
            return ['Status'=>'410','Message'=>'Payment gateway not found!'];
        }

        $headers = [
                "Authorization:".$payment_gateway->authorization,
                "Content-Type: application/json"
            ];

        $data = [
            "Token" => $req_data['Token'],
        ];

        $host=$payment_gateway->create_url?$payment_gateway->create_url:'https://spg.com.bd:6314';
        $url = $host."/api/v3/spgservice/TransactionVerificationWithToken";
      //  $url = "https://spg.sblesheba.com:6314/api/v3/spgservice/TransactionVerificationWithToken"; //for test

        $jsonData = json_encode($data);

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);          
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 
        
        $response = curl_exec($ch);
        curl_close($ch);

        $res_data=json_decode($response,true);


        $issue = new IssueDetail();
        $issue->issue_type='online-transaction-end:'.$fee_key;
        $issue->issuer_type='site';
        $issue->issue_details=$response;
        $issue->site_id=$req_data['site_id'];
        $issue->username=$req_data['username'];
        $issue->ip_address=request()->ip();
        $issue->save();

    //    dd($res_data);


        return $res_data;


    }



}