<?php

namespace App\Traits\Site\Result;

use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicReportCardDesignation;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\SiteInfo;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\Result\GlobalSiteExamResultReportSetting;
use App\Models\Site\Result\GlobalSiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\GlobalSiteResultSystemSetting;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\Exam\GlobalSiteGroupStudentExamRoll;
use App\Models\SiteGroup\Exam\SiteGroupStudentExamRoll;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPrimarySettingStore;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultSystemSettingStore;
use App\Models\SiteGroup\ExamResult\SiteGroupResultPrimarySettingStore;
use Carbon\Carbon;
use Session;
use DB;
use PDF;
use Illuminate\Support\Facades\File;

trait ExamResultTrait
{

    private function siteId()
    {

        $domain = "";
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }
        $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
        if (!$site_info) {
            $site_info = GlobalSiteInfo::where('id', Session::get('SITE_ID'))->first();
        }
        $site_id = $site_info->id;
        Session::put('SITE_ID', $site_id);

        return $site_id;
    }


    //    public function primaryResultTypeBaseResultDetails($request){

    //     $site_id = $this->siteId();
    //     $data = $request->all();

    //     if($request->student_username){
    //         $this->validate($request, [
    //             "student_username" => "required",
    //             "student_history_id" => "required",
    //             "academic_result_primary_type_id" => "required",

    //         ]);

    //         $studentHistory=GlobalStudentHistory::with('site')
    //             ->where('site_id', $site_id)
    //             ->where('id', $request->student_history_id)
    //          //   ->select('id','site_id',)
    //             ->orderBy('id','DESC')
    //             ->first();
    //     }else{
    //         $this->validate($request, [
    //             "academic_group_id" => "required",
    //             "academic_version_id" => "required",
    //             "academic_year_id" => "required",
    //             "academic_shift_id" => "required",
    //             "academic_class_id" => "required",
    //             "academic_result_primary_type_id" => "required",
    //             "student_roll_number" => "required",
    //         ]);


    //         $studentHistory=GlobalStudentHistory::with('site')
    //             ->where('site_id', $site_id)
    //             ->where('academic_group_id', $request->academic_group_id)
    //             ->where('academic_year_id', $request->academic_year_id)
    //             ->where('academic_shift_id', $request->academic_shift_id)
    //             ->where('academic_class_id', $request->academic_class_id)
    //             ->where('student_roll_number', $request->student_roll_number)
    //             ->when($data['academic_class_group_id'], function($q) use ($request){
    //             $q->where('academic_class_group_id', $request->academic_class_group_id);
    //             })
    //             ->when($data['academic_section_id'], function($q) use ($request){
    //             $q->where('academic_section_id', $request->academic_section_id);
    //             })
    //             ->when($data['site_batch_detail_id'], function($q) use ($request){
    //             $q->where('site_batch_detail_id', $request->site_batch_detail_id);
    //             })
    //            // ->select('id','site_id','student_roll_number')
    //             ->orderBy('id','DESC')
    //             ->first();

    //         }

    //        if($studentHistory){
    //             $dataaa=GlobalSiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
    //                 $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
    //                     'academic_session_id', 'academic_student_category_id', 'board_registration_number',
    //                     'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number_prefix','student_roll_number',
    //                     'registration_no');
    //                 $query->with(['student' => function ($q) {
    //                     $q->with('latestPhoto');
    //                     $q->select('id','date_of_birth');
    //                     $q->where('user_type', 'student');
    //                 },
    //                 'site','year', 'shift','department','stClass','classGroup','session','section'
    //                 ]);
    //             }, 'academicResultPrimaryType'])
    //             ->where('student_history_id', $studentHistory->id)
    //             ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
    //             ->where('result_public_publish_status', true)
    //             ->where('result_public_full_publish_status', true)
    //             ->where('status', true)
    //             ->get();

    //          //   dd(count($dataaa));


    //         if(count($dataaa)<=0){
    //             return response()->json(['message'=>'Result Not Found','status'=>false],422);
    //         }

    //        }else{
    //         return response()->json(['message'=>'Student Not Found','status'=>false],422);
    //        }

    //           // Employee
    //           $institute_head = GlobalEmployee::where('site_id',$site_id)->where('institute_head', 1)->first();
    //           $site_info =  SiteInfo::find($site_id);

    //           $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
    //           $get_designation = $institute_head->designation->name ?? 'Institution Head';


    //         $student_info=[
    //             'full_name'=>$studentHistory->full_name,
    //             'full_roll'=>$studentHistory->student_full_roll_number,
    //             'username'=>$studentHistory->student?$studentHistory->student->username:'',
    //             'father_name'=>$studentHistory->student?$studentHistory->student->father_name:'',
    //             'mother_name'=>$studentHistory->student?$studentHistory->student->mother_name:'',
    //             'date_of_birth'=>$studentHistory->student?$studentHistory->student->date_of_birth:'',
    //             'version_name'=>$studentHistory->version?$studentHistory->version->version_name:'',
    //             'shift_name'=>$studentHistory->shift?$studentHistory->shift->shift_name:'',
    //             'class_name'=>$studentHistory->stClass?$studentHistory->stClass->class_name:'',
    //             'group_name'=>$studentHistory->classGroup?$studentHistory->classGroup->group_name:'',
    //             'section_name'=>$studentHistory->section?$studentHistory->section->section_name:'',
    //             'department_name'=>$studentHistory->department?$studentHistory->department->department_name:'',
    //             'session_name'=>$studentHistory->session?$studentHistory->session->session_name:'',
    //             'year_name'=>$studentHistory->year?$studentHistory->year->year_name:'',
    //         ];


    //       $a_arr=Array();
    //       $a_array=[];

    //       foreach ($dataaa as $key => $value){

    //           $b_array=[];
    //           foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet){
    //               $b_array[]=$valuet->subject_detail;
    //           }

    //           $result_show_in_table_bellow_status_present=collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();

    //             $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
    //             $a_arr['result_public_full_publish_status']=$value->result_public_full_publish_status;
    //             $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
    //             $a_arr['student_history_id']=$value->student_history_id;
    //             $a_arr['fail_subject_count']=$value->fail_subject_count;
    //             $a_arr['gpa']=$value->gpa;
    //             $a_arr['grade']=$value->grade;
    //             $a_arr['student_rank']=$value->student_rank;
    //             $a_arr['site_result_primary_setting_id']=$value->site_result_primary_setting_id;
    //             $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
    //             $a_arr['subject_list']=$b_array;
    //             $a_arr['table_header']=$value->table_header;
    //             $a_arr['highest_marks']=json_decode($value->highest_marks_list);
    //             $a_arr['student_history']=$value->studentHistory;
    //             $a_arr['student_info']=$student_info;

    //             $a_arr['total_student']=$value->total_student;

    //             $a_arr['student_photo']=$value->studentHistory->student->latestPhoto?
    //                 $value->studentHistory->student->latestPhoto->name:'image-not.png';

    //             $a_arr['result_show_in_table_bellow_status_present']=count($result_show_in_table_bellow_status_present)>0?1:0;

    //             $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
    //             $a_arr['result_type_id']=$value->academicResultPrimaryType->id;

    //             $a_arr['classtest_is_present']=$value->classtest_is_present;
    //             $a_arr['combine_subject_present']=$value->combine_subject_present;
    //             $a_arr['final_grade_without_optional']=$value->final_grade_without_optional;
    //             $a_arr['final_point_without_optional']=$value->final_point_without_optional;
    //             $a_arr['id']=$value->id;
    //             $a_arr['raw_obtain_marks_percentage']=number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
    //             $a_arr['sum_of_obtain_percent_total_marks']=$value->sum_of_obtain_percent_total_marks;
    //             $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
    //             $a_arr['sum_of_raw_total_marks']=$value->sum_of_raw_total_marks;
    //             $a_arr['sum_of_obtain_total_marks_for_show']=$value->sum_of_obtain_total_marks_for_show;
    //           //  $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
    //           $a_arr['sum_of_obtain_total_percent_for_show']=$value->sum_of_obtain_total_percent_for_show;
    //           //$a_arr['obtain_total_marks_for_show']=$value->obtain_total_marks_for_show;

    //           $a_arr['institute_head_teacher_signature']=$get_signature;
    //           $a_arr['institute_head_teacher_designation']=$get_designation;
    //           $a_arr['address']=$site_info->site_name;
    //           $a_arr['comment']=$value->comment;

    //           $a_arr['academic_days']=$value->academic_days;
    //           $a_arr['present_days']=$value->present_days;
    //           $a_arr['absent_days']=$value->absent_days;
    //           $a_arr['behaviour']=$value->behaviour;
    //           $a_arr['cultural_activities']=$value->cultural_activities;
    //           $a_arr['bncc']=$value->bncc;
    //           $a_arr['debate']=$value->bncc;
    //           $a_arr['scout']=$value->scout;
    //           $a_arr['sports']=$value->sports;
    //           $a_arr['others']=$value->others;
    //           $a_arr['site_name']=$site_info->site_name;

    //           $a_array[$key]=array_merge($a_arr);
    //        //   $final_array[$key]=array_merge($a_arr);
    //       }


    //     $siteResultSystemSettingPresent=GlobalSiteResultSystemSetting::with(['academicResultSystem'])
    //         ->where('site_id', $site_id)
    //         ->where('academic_year_id', $studentHistory->academic_year_id)
    //         ->where('academic_version_id', $studentHistory->academic_version_id)
    //         ->where('academic_class_id', $studentHistory->academic_class_id)
    //         ->when(!empty($studentHistory->academic_group_id), function ($query) use ($studentHistory) {
    //             return $query->where('academic_group_id', $studentHistory->academic_group_id);
    //         })
    //         ->when(!empty($studentHistory->academic_department_id), function ($query) use ($studentHistory) {
    //             return $query->where('academic_department_id', $studentHistory->academic_department_id);
    //         })
    //         ->where('status',true)
    //         ->get()
    //         ->sortBy(function ($item) {
    //             return $item->academicResultSystem->serial ?? 0;
    //         });

    //     return ['result_array'=>$a_array, 'result_setting_array'=>$siteResultSystemSettingPresent];

    // }

    private function sitePrimaryResult($data, $student_history_ids, $user_key)
    {

            $dataaa = GlobalSiteStudentPrimaryResultDetail::with([
                    'studentHistory.student.latestPhoto',
                    'studentHistory.year',
                    'studentHistory.shift',
                    'studentHistory.department',
                    'studentHistory.stClass',
                    'studentHistory.classGroup',
                    'studentHistory.session',
                    'studentHistory.section',
                    'academicResultPrimaryType'
                ])
                ->join('student_histories', 'student_histories.id', '=', 'site_student_primary_result_details.student_history_id')
                ->whereIn('student_history_id', $student_history_ids)
                ->where('academic_result_primary_type_id', $data['academic_result_primary_type_id'])
                ->when($user_key == 'site_student', function ($q) {
                    return $q->where('site_student_primary_result_details.result_student_publish_status', true);
                })
                ->when($user_key == 'site_public', function ($q) {
                    return $q->where('site_student_primary_result_details.result_public_publish_status', true);
                })
                ->where('site_student_primary_result_details.status', true)
                ->where('site_student_primary_result_details.site_id', $data['site_id'])
                ->orderBy('student_histories.student_roll_number')
                ->select('site_student_primary_result_details.*')
                ->get();
                
        //    $dataaa = GlobalSiteStudentPrimaryResultDetail::with(['studentHistory' => function ($query) {
        //     $query->select(
        //         'id',
        //         'user_id',
        //         'academic_shift_id',
        //         'academic_class_id',
        //         'academic_department_id',
        //         'academic_session_id',
        //         'academic_student_category_id',
        //         'board_registration_number',
        //         'academic_class_group_id',
        //         'academic_section_id',
        //         'academic_year_id',
        //         'student_roll_number_prefix',
        //         'student_roll_number',
        //         'registration_no',
        //     );
        //     $query->with([
        //         'student' => function ($q) {
        //             $q->with('latestPhoto');
        //             $q->select('id','username','date_of_birth');
        //             $q->where('user_type', 'student');
        //         },
        //         'year',
        //         'shift',
        //         'department',
        //         'stClass',
        //         'classGroup',
        //         'session',
        //         'section'
        //     ]);
        // }, 'academicResultPrimaryType'])
        //     ->whereIn('student_history_id', $student_history_ids)
        //     ->where('academic_result_primary_type_id', $data['academic_result_primary_type_id'])
        //     ->when($user_key == 'site_student', function ($q) {
        //         return $q->where('result_student_publish_status', true);
        //     })
        //     ->when($user_key == 'site_public', function ($q) {
        //         return $q->where('result_public_publish_status', true);
        //     })
        //     ->where('status', true)
        //     ->where('site_id', $data['site_id'])
        //     ->get();

        if (!count($dataaa)) {
            return ['message' => 'You have no permission', 'status' => 410];
        }

     
        $resultSetting = GlobalSiteExamResultReportSetting::where('site_id', $data['site_id'])
            ->where('academic_group_id',$data['academic_group_id'])
            ->first();

        if(!$resultSetting){
            $resultSetting = GlobalSiteExamResultReportSetting::where('site_id', $data['site_id'])->first();
        }


            if (!$resultSetting) {
                return ['message' => 'First make rsult settings', 'status' => 410];
            }
        
        if (!$resultSetting->section_wise_highest_mark_show_status) {

            $student_ids = GlobalStudentHistory::where('academic_version_id', $data['academic_version_id'])
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('site_id', $data['site_id'])
                ->where('academic_group_id', $data['academic_group_id'])
                // ->where('status', true)
                ->pluck('id');

            $hight_marks_ids = GlobalSiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $data['academic_result_primary_type_id'])
                ->whereIn('student_history_id', $student_ids)
                ->where('status', true)
                ->pluck('exam_dependent_academic_subject_id')
                ->unique()
                ->filter();

            $hight_marks_list = [];
            foreach ($hight_marks_ids as $key => $value) {
                $hight_marks_subject = GlobalSiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $data['academic_result_primary_type_id'])
                    ->whereIn('student_history_id', $student_ids)
                    ->where('exam_dependent_academic_subject_id', $value)
                    ->where('status', true)
                    //    ->orderBy('obtain_raw_total_marks', 'desc')
                    ->orderBy('obtain_total_marks_for_show', 'desc')
                    // ->select('exam_dependent_academic_subject_id', 'obtain_raw_total_marks')
                    ->select('exam_dependent_academic_subject_id', 'obtain_total_marks_for_show', 'obtain_raw_total_marks')
                    ->first();



                if ($hight_marks_subject) {
                    $hight_marks_list[] = $hight_marks_subject;
                }
            }
        }
    
        // Employee
        $institute_head = GlobalEmployee::where('site_id', $data['site_id'])->where('institute_head', 1)->first();
        $site_info =  GlobalSiteInfo::find($data['site_id']);


        $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
        $get_designation = $institute_head->designation->name ?? 'Institution Head';


        $a_arr = array();
        $a_array = [];
        foreach ($dataaa as $key => $value) {

            $studentHistory = $value->studentHistory;

            $b_array = [];
            foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet) {
                $b_array[] = $valuet->subject_detail;
            }

            if($resultSetting){
                 if ($resultSetting->section_wise_highest_mark_show_status) {
                    $highest_marks_list = json_decode($value->highest_marks_list);
                } else {
                    $subject_ids = collect($b_array)->pluck('exam_dependent_academic_subject_id')->unique();
                    $highest_marks_list = collect($hight_marks_list)->whereIn('exam_dependent_academic_subject_id', $subject_ids);
                }
            }else{
                $subject_ids = [];
                $highest_marks_list = [];
            }

            $examRoll=null;

            // if($studentHistory->id==106227){
            //     dd('sf');
            // }

    
            $result_show_in_table_bellow_status_present = collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();

            $student_info = [
                'full_name' => $studentHistory->full_name,
                'full_roll' => $studentHistory->student_full_roll_number,
                'username' => $studentHistory->student ? $studentHistory->student->username : '',
                'father_name' => $studentHistory->student ? $studentHistory->student->father_name : '',
                'mother_name' => $studentHistory->student ? $studentHistory->student->mother_name : '',
                'date_of_birth' => $studentHistory->student ? $studentHistory->student->date_of_birth : '',
                'version_name' => $studentHistory->version ? $studentHistory->version->version_name : '',
                'shift_name' => $studentHistory->shift ? $studentHistory->shift->shift_name : '',
                'class_name' => $studentHistory->stClass ? $studentHistory->stClass->class_name : '',
                'group_name' => $studentHistory->classGroup ? $studentHistory->classGroup->group_name : '',
                'section_name' => $studentHistory->section ? $studentHistory->section->section_name : '',
                'department_name' => $studentHistory->department ? $studentHistory->department->department_name : '',
                'session_name' => $studentHistory->session ? $studentHistory->session->session_name : '',
                'year_name' => $studentHistory->year ? $studentHistory->year->year_name : '',
                'central_exam_roll' => '',
            ];

            $a_arr['student_info'] = $student_info;
            $a_arr['result_type_name'] = $value->academicResultPrimaryType->name;
            $a_arr['student_history_id'] = $value->student_history_id;
            $a_arr['fail_subject_count'] = $value->fail_subject_count;
            $a_arr['gpa'] = $value->gpa;
            $a_arr['grade'] = $value->grade;

            $a_arr['student_rank'] = $value->student_rank;
            $a_arr['central_rank'] = $value->central_rank;
            $a_arr['site_result_primary_setting_id'] = $value->site_result_primary_setting_id;
            $a_arr['academic_result_primary_type_id'] = $value->academic_result_primary_type_id;
            $a_arr['subject_list'] = $b_array;
            $a_arr['table_header'] = $value->table_header;
            $a_arr['sheet_header'] = $value->sheet_header;
            $a_arr['highest_marks'] = $highest_marks_list;
            $a_arr['student_history'] = $value->studentHistory;

            ///   $a_arr['total_student']=count($student_ids);
            $a_arr['total_student'] = $value->total_student;

            $a_arr['student_photo'] = $value->studentHistory->student->latestPhoto ?
                $value->studentHistory->student->latestPhoto->name : 'image-not.png';

            $a_arr['result_show_in_table_bellow_status_present'] = count($result_show_in_table_bellow_status_present) > 0 ? 1 : 0;

            $a_arr['result_type_name'] = $value->academicResultPrimaryType->name;
            $a_arr['result_type_id'] = $value->academicResultPrimaryType->id;

            $a_arr['classtest_is_present'] = $value->classtest_is_present;
            $a_arr['combine_subject_present'] = $value->combine_subject_present;
            $a_arr['final_grade_without_optional'] = $value->final_grade_without_optional;
            $a_arr['final_point_without_optional'] = $value->final_point_without_optional;
            $a_arr['id'] = $value->id;
            $a_arr['raw_obtain_marks_percentage'] = number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
            $a_arr['sum_of_obtain_percent_total_marks'] = $value->sum_of_obtain_percent_total_marks;
            $a_arr['sum_of_obtain_raw_total_marks'] = $value->sum_of_obtain_raw_total_marks;
            $a_arr['sum_of_raw_total_marks'] = $value->sum_of_raw_total_marks;
            $a_arr['sum_of_obtain_total_marks_for_show'] = $value->sum_of_obtain_total_marks_for_show;
            $a_arr['sum_of_obtain_total_percent_for_show'] = $value->sum_of_obtain_total_percent_for_show;
         //   $a_arr['exam_attendance_status']=$value->exam_attendance_status;

            $a_arr['institute_head_teacher_signature'] = $get_signature;
            $a_arr['institute_head_teacher_designation'] = $get_designation;
            $a_arr['address'] = $site_info->site_name;

            $a_arr['comment'] = $value->comment;
            $a_arr['comment_two'] = $value->comment_two;
            $a_arr['academic_days'] = $value->academic_days;
            $a_arr['present_days'] = $value->present_days;
            $a_arr['absent_days'] = $value->absent_days;
            $a_arr['behaviour'] = $value->behaviour;
            $a_arr['cultural_activities'] = $value->cultural_activities;
            $a_arr['bncc'] = $value->bncc;
            $a_arr['debate'] = $value->bncc;
            $a_arr['scout'] = $value->scout;
            $a_arr['sports'] = $value->sports;
            $a_arr['others'] = $value->others;
            $a_arr['punctuality'] = $value->punctuality??0;
            $a_arr['obedience'] = $value->obedience??0;
            $a_arr['attentiveness'] = $value->attentiveness??0;
            $a_arr['classroom_behaviour'] = $value->classroom_behaviour??0;
            $a_arr['commitment'] = $value->commitment??0;
            $a_arr['cleanliness'] = $value->cleanliness??0;
            $a_arr['handwriting'] = $value->handwriting??0;
            $a_arr['homework'] = $value->homework??0;
            $a_arr['classwork'] = $value->classwork??0;

            $a_arr['result_generated_by'] = $value->result_generated_by;
            $a_arr['result_public_full_publish_status'] = $value->result_public_full_publish_status;

           // dd($a_arr['table_header']->grade_list);

            $a_array[$key] = array_merge($a_arr);
        }

       // dd($a_array);

   

        $academic_primary_type = AcademicResultPrimaryType::where('id', $data['academic_result_primary_type_id'])
            ->where('use_key', 'site_group')
            ->first();
        $siteResultSystemSettingPresent = [];

        if (!$academic_primary_type) {
            $siteResultSystemSettingPresent = GlobalSiteResultSystemSetting::with(['academicResultSystem'])
                ->where('site_id', $data['site_id'])
                ->where('academic_group_id', $data['academic_group_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('status', true)
                ->get()
                ->sortBy(function ($item) {
                    return $item->academicResultSystem->serial ?? 0;
                });

               //  dd($data,$siteResultSystemSettingPresent);
        } 

        return ['result_array' => $a_array, 'result_setting_array' => $siteResultSystemSettingPresent, 'message' => 'success', 'status' => 200];
   
    }

     private function siteGroupPrimaryResult($data, $student_history_ids, $user_key)
    {

        $checkPermission=GlobalSiteGroupResultPermission::where('academic_year_id',$data['academic_year_id'])
            ->where('academic_class_id',$data['academic_class_id'])
            ->where('site_id',$data['site_id'])
            ->where('academic_group_id',$data['academic_group_id'])
            ->when($user_key=='site_admin', function ($query){
                return $query->where('site_result_permission_status', true);
            })
            ->when($user_key=='site_employee', function ($query){
                return $query->where('employee_result_permission_status', true);
            })
            ->when($user_key=='site_student', function ($query){
                return $query->where('student_result_permission_status', true);
            })
            ->when($user_key=='site_public', function ($query){
                return $query->where('public_result_permission_status', true);
            })
            ->first();

           // dd($user_key,$data);

            if(!$checkPermission){
                return ['result_array' => '', 'result_setting_array' =>'', 'message' => 'Permission Denied!', 'status' => 410];
            }


        $dataaa = GlobalSiteStudentPrimaryResultDetail::with(['studentHistory' => function ($query) {
            $query->select('id','user_id','academic_shift_id','academic_class_id','academic_department_id','academic_session_id','academic_student_category_id',
                'board_registration_number','academic_class_group_id','academic_section_id','academic_year_id','student_roll_number_prefix','student_roll_number','registration_no',
            );
            $query->with([
                'student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id','username','date_of_birth');
                    $q->where('user_type', 'student');
                },
                'year','shift','department','stClass','classGroup','session','section'
            ]);
        }, 'academicResultPrimaryType'])
            ->whereIn('student_history_id', $student_history_ids)
            ->where('academic_result_primary_type_id', $data['academic_result_primary_type_id'])
          //  ->where('status', true)
            ->where('site_id', $data['site_id'])
            ->get();

          


        // Employee
        $institute_head = GlobalEmployee::where('site_id', $data['site_id'])->where('institute_head', 1)->first();
        $site_info =  GlobalSiteInfo::find($data['site_id']);


        $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
        $get_designation = $institute_head->designation->name ?? 'Institution Head';

 //dd($dataaa);
        $a_arr = array();
        $a_array = [];
        foreach ($dataaa as $key => $value) {

            $studentHistory = $value->studentHistory;

            $b_array = [];
            foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet) {

                $b_array[] = $valuet->subject_detail;
            }


            $highest_marks_list = json_decode($value->highest_marks_list);

   
            $result_show_in_table_bellow_status_present = collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();

            $student_info = [
                'full_name' => $studentHistory->full_name,
                'full_roll' => $studentHistory->student_full_roll_number,
                'username' => $studentHistory->student ? $studentHistory->student->username : '',
                'father_name' => $studentHistory->student ? $studentHistory->student->father_name : '',
                'mother_name' => $studentHistory->student ? $studentHistory->student->mother_name : '',
                'date_of_birth' => $studentHistory->student ? $studentHistory->student->date_of_birth : '',
                'version_name' => $studentHistory->version ? $studentHistory->version->version_name : '',
                'shift_name' => $studentHistory->shift ? $studentHistory->shift->shift_name : '',
                'class_name' => $studentHistory->stClass ? $studentHistory->stClass->class_name : '',
                'group_name' => $studentHistory->classGroup ? $studentHistory->classGroup->group_name : '',
                'section_name' => $studentHistory->section ? $studentHistory->section->section_name : '',
                'department_name' => $studentHistory->department ? $studentHistory->department->department_name : '',
                'session_name' => $studentHistory->session ? $studentHistory->session->session_name : '',
                'year_name' => $studentHistory->year ? $studentHistory->year->year_name : '',
                'central_exam_roll' => $value->examination_roll??'',
            ];

            $a_arr['student_info'] = $student_info;
            $a_arr['result_type_name'] = $value->academicResultPrimaryType->name;
            $a_arr['student_history_id'] = $value->student_history_id;
            $a_arr['fail_subject_count'] = $value->fail_subject_count;
            $a_arr['gpa'] = $value->gpa;
            $a_arr['grade'] = $value->grade;

            $a_arr['student_rank'] = $value->student_rank;
            $a_arr['central_rank'] = $value->central_rank;
            $a_arr['site_result_primary_setting_id'] = $value->site_result_primary_setting_id;
            $a_arr['academic_result_primary_type_id'] = $value->academic_result_primary_type_id;
            $a_arr['subject_list'] = $b_array;
            $a_arr['table_header'] = $value->table_header;
            $a_arr['sheet_header'] = $value->sheet_header;
            $a_arr['highest_marks'] = $highest_marks_list;
            $a_arr['student_history'] = $value->studentHistory;

            ///   $a_arr['total_student']=count($student_ids);
            $a_arr['total_student'] = $value->total_student;

            $a_arr['student_photo'] = $value->studentHistory->student->latestPhoto ?
                $value->studentHistory->student->latestPhoto->name : 'image-not.png';

            $a_arr['result_show_in_table_bellow_status_present'] = count($result_show_in_table_bellow_status_present) > 0 ? 1 : 0;

            $a_arr['result_type_name'] = $value->academicResultPrimaryType->name;
            $a_arr['result_type_id'] = $value->academicResultPrimaryType->id;

            $a_arr['classtest_is_present'] = $value->classtest_is_present;
            $a_arr['combine_subject_present'] = $value->combine_subject_present;
            $a_arr['final_grade_without_optional'] = $value->final_grade_without_optional;
            $a_arr['final_point_without_optional'] = $value->final_point_without_optional;
            $a_arr['id'] = $value->id;
            $a_arr['raw_obtain_marks_percentage'] = number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
            $a_arr['sum_of_obtain_percent_total_marks'] = $value->sum_of_obtain_percent_total_marks;
            $a_arr['sum_of_obtain_raw_total_marks'] = $value->sum_of_obtain_raw_total_marks;
            $a_arr['sum_of_raw_total_marks'] = $value->sum_of_raw_total_marks;
            $a_arr['sum_of_obtain_total_marks_for_show'] = $value->sum_of_obtain_total_marks_for_show;
            $a_arr['sum_of_obtain_total_percent_for_show'] = $value->sum_of_obtain_total_percent_for_show;
            //  $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;

            $a_arr['institute_head_teacher_signature'] = $get_signature;
            $a_arr['institute_head_teacher_designation'] = $get_designation;
            $a_arr['address'] = $site_info->site_name;

            $a_arr['comment'] = $value->comment;
            $a_arr['academic_days'] = $value->academic_days;
            $a_arr['present_days'] = $value->present_days;
            $a_arr['absent_days'] = $value->absent_days;
            $a_arr['behaviour'] = $value->behaviour;
            $a_arr['cultural_activities'] = $value->cultural_activities;
            $a_arr['bncc'] = $value->bncc;
            $a_arr['debate'] = $value->bncc;
            $a_arr['scout'] = $value->scout;
            $a_arr['sports'] = $value->sports;
            $a_arr['others'] = $value->others;
            $a_arr['result_generated_by'] = $value->result_generated_by;
            $a_arr['result_public_full_publish_status'] = $checkPermission->public_result_permission_status;

           // dd($a_arr['table_header']->grade_list);

            $a_array[$key] = array_merge($a_arr);
        }

   
        $siteResultSystemSettingPresent = GlobalSiteGroupResultSystemSettingStore::with(['academicResultSystem'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('status', true)
            ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
            ->get()
            ->sortBy(function ($item) {
                return $item->academicResultSystem->serial ?? 0;
            });



        return ['result_array' => $a_array, 'result_setting_array' => $siteResultSystemSettingPresent, 'message' => 'success', 'status' => 200];
   

    }


    public function primaryResultTypeBaseResultDetails($data, $student_history_ids, $user_key)
    {
         
 //dd($data);

        $primaryResult = AcademicResultPrimaryType::find($data['academic_result_primary_type_id']);
        if($primaryResult->use_key=='site'){
            $result_details=$this->sitePrimaryResult($data, $student_history_ids,$user_key);
        }else{
            $result_details=$this->siteGroupPrimaryResult($data, $student_history_ids, $user_key);
        }

        

        if($result_details['status']!=200){
           return ['message' => $result_details['message'], 'status' => $result_details['status']];
        }


        return ['result_array' => $result_details['result_array'], 'result_setting_array' => $result_details['result_setting_array'], 'message' => $result_details['message'], 'status' => $result_details['status']];

    }



    public function studentResulDetailsPdf($data, $student_ids, $user_key)
    {

       ini_set('memory_limit', '1024M'); // 1GB
       set_time_limit(600); // 10 minutes

      //  ini_set('memory_limit', '-1');

        $is_qrcode = true;
        $is_stdImage = true;
        $is_academic_perform = true;
        $head_signature_status = false;
        $report_tittle = '';
        $report_tittle2 = '';

      

        $primaryResultList =  $this->primaryResultTypeBaseResultDetails($data, $student_ids, $user_key);


        if ($primaryResultList['status'] != 200) {
            return ['message' => $primaryResultList['message'], 'status' => $primaryResultList['status']];
        }

        $result_list_array = $primaryResultList['result_array'];
        $result_system_list = $primaryResultList['result_setting_array'];


        $site_info =  GlobalSiteInfo::find($data['site_id']);

        $scheme = request()->getScheme(); // এটা http না https সেটা রিটার্ন করে

        $domain = $site_info->domain_name;

        if (!$domain) {
            $alias = $site_info->site_alias;
            $hostParts = explode('.', request()->getHost());

            if ($hostParts[0] === $alias) {
                $domain = implode('.', $hostParts);
            } else {
                $partsCount = count($hostParts);

                if ($partsCount >= 2) {
                    $mainDomain = implode('.', array_slice($hostParts, -2));
                } else {
                    $mainDomain = implode('.', $hostParts);
                }

                $domain = $alias . '.' . $mainDomain;
            }
        }

        $domain = $scheme . '://' . $domain;


 
        $year = AcademicYear::find($data['academic_year_id']);
        $primaryResult = AcademicResultPrimaryType::find($data['academic_result_primary_type_id']);

        if($primaryResult->use_key=='site'){

            $resultSetting = GlobalSiteExamResultReportSetting::where('site_id', $data['site_id'])
                ->where('academic_group_id',$data['academic_group_id'])
                ->where('academic_version_id',$data['academic_version_id'])
                ->where('academic_year_id',$data['academic_year_id'])
                ->where('academic_class_id',$data['academic_class_id'])
                ->where('academic_result_primary_type_id',$data['academic_result_primary_type_id'])
                ->first();

                // dd($resultSetting);

        if(!$resultSetting){
            $resultSetting = GlobalSiteExamResultReportSetting::where('site_id', $data['site_id'])->first();
        }

            if (!$resultSetting) {
                $resultSetting = [
                    'sheet_no' => 'one',
                    'site_address_show_status' => true,
                    'exam_type_show_status' => true,
                    'std_image_show_status' => true,
                    'qrcode_show_status' => true,
                    'countable_mark_show_status' => false,
                    'row_mark_show_status' => false,
                    'mark_percentage_show_status' => true,
                    'academic_perform_show_status' => true,
                    'behaviour_show_status' => true,
                    'curriculam_activities_show_status' => true,
                    'merit_list_show_status' => true,
                    'head_signature_show_status' => '',
                    'left_designation' => null,
                    'center_designation' => null,
                    'right_designation' => 'Institute Head',
                    'pdf_type' => 'portrait',
                ];
            }

            if ($user_key == 'site_student' || $user_key == 'site_public') {
                if (!$resultSetting->signature_show_status_for_public) {
                    $resultSetting['head_signature_show_status'] = false;
                }
            }



        if ($resultSetting['sheet_no'] == 'two') {

            if ($resultSetting['pdf_type'] == 'portrait') {
                $pdf = PDF::loadView(
                    'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-two',
                    compact('result_list_array', 'year', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
                )
                    ->setWarnings(false);
            } else if ($resultSetting['pdf_type'] == 'landscape') {
                $pdf = PDF::loadView(
                    'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report-two',
                    compact('result_list_array', 'year', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
                )
                    ->setPaper('a4', 'landscape')->setWarnings(false);
            }
        } elseif ($resultSetting['sheet_no'] == 'three') {
            if ($resultSetting['pdf_type'] == 'portrait') {
                $pdf = PDF::loadView(
                    'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-three',
                    compact('result_list_array', 'year', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
                )
                    ->setWarnings(false);
            } else if ($resultSetting['pdf_type'] == 'landscape') {
                $pdf = PDF::loadView(
                    'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report-two',
                    compact(
                        'result_list_array',
                        'report_tittle',
                        'report_tittle2',
                        'result_system_list',
                        'domain',
                        'resultSetting',
                        'site_info',
                        'year',
                    )
                )
                    ->setPaper('a4', 'landscape')->setWarnings(false);
            }
        } elseif ($resultSetting['sheet_no'] == 'four') {

            // if ($resultSetting['pdf_type'] == 'portrait') {

            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-four',
                compact('result_list_array', 'year', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
            //  }
            // else{

            // $pdf = PDF::loadView(
            //     'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report',
            //     compact('result_list_array','report_tittle','report_tittle2','result_system_list','domain','resultSetting','site_info')
            // )
            //     ->setPaper('a4', 'landscape')->setWarnings(false);
            // }

        }
        elseif ($resultSetting['sheet_no'] == 'five') {
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-five',
                compact('result_list_array', 'report_tittle','year', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
            // if ($resultSetting['pdf_type'] == 'portrait') {
            // }
        }
        elseif ($resultSetting['sheet_no'] == 'six') {
            // dd('jahin');
            $pdf = PDF::loadView(
                'default.admin.site_group.result.result_report.site-group-base-multiple-student-result-detail-report',
                compact('result_list_array', 'report_tittle','year', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
            // if ($resultSetting['pdf_type'] == 'portrait') {
            // }
        }
        elseif ($resultSetting['sheet_no'] == 'seven') {
            // dd('jahin');
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-seven',
                compact('result_list_array', 'report_tittle','year', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
            // if ($resultSetting['pdf_type'] == 'portrait') {
            // }
        }
        elseif ($resultSetting['sheet_no'] == 'eight') {
            // dd('jahin');
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-eight',
                compact('result_list_array', 'report_tittle','year', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
            // if ($resultSetting['pdf_type'] == 'portrait') {
            // }
        }
        elseif ($resultSetting['sheet_no'] == 'nine') {
            // dd('jahin');
            $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-nine-cambridge',
                compact('result_list_array', 'report_tittle','year', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
            )
                ->setWarnings(false);
            // if ($resultSetting['pdf_type'] == 'portrait') {
            // }
        }
        else {

            if ($resultSetting['pdf_type'] == 'portrait') {
                $pdf = PDF::loadView(
                    'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report',
                    compact('result_list_array', 'year', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
                )
                    ->setWarnings(false);
            } else if ($resultSetting['pdf_type'] == 'landscape') {
                $pdf = PDF::loadView(
                    'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report',
                    compact('result_list_array', 'year', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
                )
                    ->setPaper('a4', 'landscape')->setWarnings(false);
            }
        }
    }else{
       $pdf = PDF::loadView(
                'default.admin.site_group.result.result_report.site-group-base-multiple-student-result-detail-report',
                compact('result_list_array', 'report_tittle','year', 'report_tittle2', 'result_system_list', 'domain', 'site_info')
            )->setWarnings(false);
    }

   

        //======temporary condition=======
        if($data['site_id']==161 && $data['academic_class_id']==24){
                $pdf = PDF::loadView(
                'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-eight',
                compact('result_list_array', 'year', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'site_info')
            )
                ->setWarnings(false);
        }

        $path = storage_path() . '/pdf';

    
        $random = rand(0, 100000);
        $time = $random . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        $stream_pdf = $pdf->stream($name);

        $fullPath = $path . '/' . $name;

        return ['stream_pdf' => $stream_pdf, 'full_path' => $fullPath, 'file_name' => $name, 'message' => 'success', 'status' => 200];

    }
}
