<?php

namespace App\Traits\Site\UserPermission;

use App\Models\Modules\SubModule;
use App\Models\Permission\UserPermission;
use App\User;
use Carbon\Carbon;

trait UserAccessTrait
{
    public function setUserPermission($users)
    {


        foreach ($users as $k => $user_id) {

            $the_user = (new User())->where('status', true)->find($user_id);

            if ($the_user) {
                $this->setTheUserPermission($the_user);
            }
        }
    }

    public function setTheUserPermission($the_user)
    {


        $sm_ids = null;
        $palette_ids = null;

        foreach ($the_user->siteRoles as $ke => $role) {
            if (!$role->groupAccess) {
                continue;
            }
            $sm_ids .= $role->groupAccess->sub_module_ids . ',';
            $palette_ids .= $role->groupAccess->dashboard_palettes ? ($role->groupAccess->dashboard_palettes . ',') : null;

        }

        if (!$sm_ids) {
            return false;
        }

        $exploded_sm_ids = explode(',', $sm_ids);
        $menus = SubModule::whereIn('id', $exploded_sm_ids)->pluck('menu_ids')->toArray();

        $imploded_menu_ids = implode(',', array_filter($menus));
        $ex_menu_ids = implode(',', array_unique(explode(',', $imploded_menu_ids)));

        /*
                 \Log::info($exploded);
                \Log::info($menus);
                 \Log::info($ex_menu_ids);*/

        $user_permission = (new UserPermission())
                ->where('user_id', $the_user->id)
                ->first() ?? (new UserPermission());

        $user_permission->user_id = $the_user->id;
        $user_permission->menu_ids = $ex_menu_ids;
        $user_permission->dashboard_palettes = $palette_ids;
        $user_permission->updated_at = Carbon::now();
        $user_permission->save();


    }
}