<?php

namespace App\Traits;

use App\Models\Edu\SMS\SmsFollowUp;
use App\Models\Site\SiteMembership;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;

trait SmsApiTrait
{
    private $follow_up;

    public function started($numbers_array, $sms_data, $company)
    {
         
        $to_numbers = is_array($numbers_array) ? implode(',', $numbers_array) : $numbers_array;

        $sms_txt = $sms_data['sms_txt'];
        $edu_charged_from_client = $sms_data['total_sms_charges'] ?? .40;
        $sms_bearer = $sms_data['sms_bearer'];
        $sms_bearer_id = $sms_data['sms_bearer_id'];

        $this->follow_up = new SmsFollowUp();
        $this->follow_up->sms_request = json_encode($sms_data);
        $this->follow_up->company = '';
        $this->follow_up->msg_txt = $sms_txt;
        $this->follow_up->msg_numbers = $to_numbers;
        $this->follow_up->institution_type = $sms_bearer;
        $this->follow_up->institution_id = $sms_bearer_id;
        $this->follow_up->edu_charged_from_client = $edu_charged_from_client;

        $this->follow_up->save();

        return $this->follow_up;
    }


    public function finished()
    {

        $this->follow_up->sent_status = true;
      //  $this->follow_up->save();
        return $this->follow_up;
    }


    public function sendSmsDynamicApi($numbers_array, $sms_data)
    {
        // add banglishi country code condition start
        $n_array[]=null;
        foreach ($numbers_array as $key=>$value) {

            $vl=substr( $value, 0, 1 );
            if($vl=='1'){
                $n_array[$key] = '880' . $value;
            }elseif($vl=='0'){
                $n_array[$key] = '88' . $value;
            }
            elseif($vl=='8'){
                $n_array[$key] = $value;
            }else{
                $n_array[$key] = $value;
            }
          
        }
       $numbers_array=$n_array;
       //===

        $sms_company = $sms_data['sms_company'] ?? 'smsinbd';// default

        if ($sms_company == 'mobireach') {

            $this->started($numbers_array, $sms_data, 'mobireach');
            return $this->sendSmsMobireach($numbers_array, $sms_data);
        } else if ($sms_company == 'smsinbd') {//sms in bd

            $this->started($numbers_array, $sms_data, 'smsinbd');
            return $this->sendSmsSmsInBd($numbers_array, $sms_data);
        
        } else if ($sms_company == 'viatech') {//via tech

            $this->started($numbers_array, $sms_data, 'viatech');
            return $this->sendSmsViaTech($numbers_array, $sms_data);
       
        } else if ($sms_company == 'zamanit') {//zamanit

            $this->started($numbers_array, $sms_data, 'zamanit');
            return $this->sendSmsZamanIt($numbers_array, $sms_data);
        
        } else if ($sms_company == 'rtcom') {//zamanit

            $this->started($numbers_array, $sms_data, 'rtcom');
            return $this->sendSmsRtCom($numbers_array, $sms_data);
        }
         else {//zamanit
            return 'error';
        }
    }


    public function sendSmsZamanIt($numbers_array, $sms_data)//Sms in bd
    {

        $sms_numbers = $numbers_array;
        $sms_txt = $sms_data['sms_txt'];
        $sms_count = $sms_data['sms_count'];
        $edu_charged_from_client = $sms_data['total_sms_charges'];
        $sms_type = $sms_data['sms_type'];
        $sms_masking = $sms_data['sms_masking'] ?? "8809617609850";//sms_in_bd default masking 8809612451743
        $sms_bearer = $sms_data['sms_bearer'];
        $sms_bearer_id = $sms_data['sms_bearer_id'];
        
        $to_numbers = is_array($sms_numbers) ? implode('+', $sms_numbers) : $sms_numbers;
        // $message_text_ue = urlencode($sms_txt);
        $message_text = $sms_txt;
        $type = ($sms_type == 'unicode' ? 'unicode' : 'text');
        $api_key = '01670338869.BNS6XbiMQSJAGRLwOG';
        
        ///============ new
        $url = "https://sms.zaman-it.com/api/sendsms";
        $data = [
          [
            "api_key" => $api_key,
            "type" => $type,
            "phone" => $to_numbers,
            "senderid" => "8809617609850",
            "message" => $message_text,
          ]
        ];

      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, $url);
      curl_setopt($ch, CURLOPT_POST, 1);
      curl_setopt($ch, CURLOPT_POSTFIELDS, $data[0]);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
      $response = curl_exec($ch);
      curl_close ($ch); 

      $follow_up = $this->follow_up;
      $array =  json_decode( preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $response), true );   

          if($array['status_code']>=1000){
           $status=0;
           $response_id=0;

          }else{
            $status=1;
            $number = rand(100,100000);
            $t=time();
            $response_id = $number.''.$t;

          }
        
        $follow_up->company = 'zamanit';
        $follow_up->msg_txt = $message_text;

        if ($status) {
            $company_charged = (.24 * $sms_count);
            $follow_up->sent_status = 1;

            $follow_up->sent_masking = $sms_masking;
            $follow_up->res_txt_json = json_encode($array);

            $follow_up->res_sms_count = $sms_count;
            $follow_up->res_current_credit = 0;//not sent by smsinbd
            $follow_up->res_msg_id = $response_id ?? 0;
            $follow_up->company_charged_from_edu = $company_charged;
            $follow_up->res_status = $status;

        } else {//error now return back balance to user

            $returned_balance = $this->returnBackSmsBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id);
            $follow_up->returned_charges = $returned_balance;
            $follow_up->res_error_code=json_encode($array['status_code']??0);
            $follow_up->sent_status = 0;
            $follow_up->res_txt_json = json_encode($array);
            $follow_up->res_msg_id =0;
            $follow_up->res_status = $status;


        }

        $follow_up->save();
    
        $time = Carbon::now()->toDateTimeString();

        $response = [];
        $response['followup_id'] = $follow_up->id;
        $response['sms_api_id'] = $response_id ?? 0;
        $response['sms_company'] = 'zamanit';
        $response['sms_sent_status'] = $status;
        $response['sent_time'] = date('Y-m-d H:i:s', strtotime($time));

        return $response;
  
    }

    public function sendSmsRtCom($numbers_array, $sms_data)//Via Tech
    {
      
        $sms_numbers = $numbers_array;
        $sms_txt = $sms_data['sms_txt'];
        $sms_count = $sms_data['sms_count'];
        $edu_charged_from_client = $sms_data['total_sms_charges'];
        $sms_type = $sms_data['sms_type'];
        $sms_masking = $sms_data['sms_masking'] ?? "8809617612695";//sms_in_bd default masking 8809612451743
        $sms_bearer = $sms_data['sms_bearer'];
        $sms_bearer_id = $sms_data['sms_bearer_id'];
        
        $to_numbers = is_array($sms_numbers) ? implode('+', $sms_numbers) : $sms_numbers;
        // $message_text_ue = urlencode($sms_txt);
        $message_text = $sms_txt;
        $type = ($sms_type == 'unicode' ? 'unicode' : 'text');
        $api_code = '30000047';
        $api_key = '51cedf50f34d663b65c31b0070666eb2f3850c24';

        $post_values = [
            "acode"=> $api_code,
            "api_key"=> $api_key,
            "senderid"=> $sms_masking,
            "type"=> $type,
            "msg"=> $message_text,
            "contacts"=> $to_numbers,
            "transactionType"=> "T",
            "contentID"=> "",
        ];

        ///============ new
      //  $post_string = "";
        // foreach( $post_values as $key => $value )
        //     { $post_string .= "$key=" . urlencode( $value ) . "&"; }

      //  $post_string = rtrim( $post_string, "& " );

      //  $url='https://api.rtcom.xyz/onetomany?'.$post_string;
        $base_url = 'https://api.rtcom.xyz/onetomany';

        $url = $base_url . '?' . http_build_query($post_values);
    
        $crl = curl_init();
        curl_setopt($crl, CURLOPT_URL, $url); 
        curl_setopt($crl, CURLOPT_RETURNTRANSFER, true); 
        curl_setopt($crl, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($crl, CURLOPT_SSL_VERIFYPEER, false); 
     //   curl_setopt($crl, CURLOPT_FRESH_CONNECT, true);
        
        $response_data = curl_exec($crl);
        curl_close ($crl); 

      $follow_up = $this->follow_up;
      $array =  json_decode( preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $response_data), true );   

        if($array['response']){
            $follow_up->company = 'rtcom';
            $follow_up->msg_txt = $message_text;

            if ($array['response']['code']==200) {
                $status=1;
                $company_charged = $array['info']['smsCharge'];
                $follow_up->sent_status = 1;
                $follow_up->sent_masking = $sms_masking;
                $follow_up->res_txt_json = json_encode($array);
                $follow_up->res_sms_count = $sms_count;
                $follow_up->res_current_credit = 0;//not sent by smsinbd
                $follow_up->res_msg_id = $array['info']['requestID'] ?? 0;
                $follow_up->company_charged_from_edu = $company_charged;
                $follow_up->res_status = $status;
                $follow_up->save();

            } else {//error now return back balance to user
                $status=0;
                $returned_balance = $this->returnBackSmsBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id);
                $follow_up->returned_charges = $returned_balance;
                $follow_up->res_error_code=json_encode($array['response']['code']);
                $follow_up->sent_status = 0;
                $follow_up->res_txt_json = json_encode($array);
                $follow_up->res_msg_id =0;
                $follow_up->res_status = $status;
                $follow_up->save();

            }

        $time = Carbon::now()->toDateTimeString();

        $response = [];
        $response['followup_id'] = $follow_up->id;
        $response['sms_api_id'] = $response_id ?? 0;
        $response['sms_company'] = 'rtcom';
        $response['sms_sent_status'] = $status;
        $response['sent_time'] = date('Y-m-d H:i:s', strtotime($time));

        return $response;
        
        }

    
      
    }
    
    public function sendSmsViaTech($numbers_array, $sms_data)//Via Tech
    {
        //9 parameter needed to cal this function

        $sms_numbers = $numbers_array;
        $sms_txt = $sms_data['sms_txt'];
        $sms_count = $sms_data['sms_count'];
        $edu_charged_from_client = $sms_data['total_sms_charges'];
        $sms_type = $sms_data['sms_type'];
        $sms_masking = $sms_data['sms_masking'] ?? '8809612442458';//sms_in_bd default masking
        $sms_bearer = $sms_data['sms_bearer'];
        $sms_bearer_id = $sms_data['sms_bearer_id'];

        $masking = str_replace(" ", "%20", $sms_masking);

        $to_numbers = is_array($sms_numbers) ? implode('+', $sms_numbers) : $sms_numbers;
       // $message_text_ue = urlencode($sms_txt);
        // $message_text = str_replace("[nl]", " ", $sms_txt);

      //  $message_text = str_replace("%5Bnl%5D", "%0A", $message_text_ue);
        $type = ($sms_type == 'unicode' ? 'unicode' : 'text');

        ////===== new =========
        $api_key = 'C2002260640577f923b826.76123092';
        $url = "http://sms.viatech.com.bd/smsapi";
        $data = [
          "api_key" => $api_key,
          "type" => $type,
          "contacts" => $to_numbers,
          "senderid" => "8809612444530",
          "msg" => $sms_txt,
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);
      //  dd($response);
       
     
        $array =  json_decode( preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $response), true );   
     
        $org_message_text = str_replace("[nl]", " ", $sms_txt);

        $sms_id = substr($response, 20);
        $status=$sms_id?true:false;
       
        $follow_up = $this->follow_up;

     //   $follow_up->sent_status = true;

        $follow_up->company = 'viatech';

        if ($status) {

            $follow_up->sent_status = $status;
    
            $follow_up->sent_masking = $sms_masking;
            $follow_up->res_txt_json = $response;
            $follow_up->msg_txt = $org_message_text;
            $follow_up->res_sms_count = $sms_count;
            $follow_up->res_current_credit = 0;//not sent by smsinbd
            $follow_up->res_msg_id = $sms_id ?? 0;
            $follow_up->res_status = $status;

    
         } else {//error now return back balance to user

            $returned_balance = $this->returnBackSmsBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id);
            $follow_up->returned_charges = $returned_balance;
            $follow_up->res_error_txt = $response;
            $follow_up->res_error_code = $response?? 0;
            $follow_up->res_txt_json = $response;
            $follow_up->res_status = $status;
            $follow_up->res_msg_id = 0;
            $follow_up->sent_status = 0;

            $follow_up->msg_txt = $sms_txt;
            $follow_up->sent_masking = $sms_masking;

         }
        $follow_up->save();

        $time = Carbon::now()->toDateTimeString();

        $responses = [];
        $responses['followup_id'] = $follow_up->id;
        $responses['sms_api_id'] = $sms_id ?? 0;
        $responses['sms_company'] = 'viatech';
        $responses['sms_sent_status'] = $status;
        $responses['sent_time'] = date('Y-m-d H:i:s', strtotime($time));

        return $responses;

    }

    public function sendSmsSmsInBd($numbers_array, $sms_data)//Sms in bd
    {
      //  dd('sfsf');

        $sms_numbers = $numbers_array;
        $sms_txt = $sms_data['sms_txt'];
        $sms_count_test = $sms_data['sms_count'];
        $edu_charged_from_client = $sms_data['total_sms_charges'];
        $sms_type = $sms_data['sms_type'];
        $sms_masking = $sms_data['sms_masking'] ?? '8809612442476';
        $sms_bearer = $sms_data['sms_bearer'];
        $sms_bearer_id = $sms_data['sms_bearer_id'];
        $per_sms_cost = $sms_data['per_sms_cost'];

        $masking = str_replace(" ", "%20", $sms_masking);

        $to_numbers = is_array($sms_numbers) ? implode(',', $sms_numbers) : $sms_numbers;
        $message_text_ue = urlencode($sms_txt);
        // $essage_text = str_replace("[nl]", " ", $sms_txt);

        $type = ($sms_type == 'unicode' ? 'unicode' : 'text');
        

        $post_url = "http://services.powersms.biz/sendSms" ;  
      
        $post_values = array( 
            'user_id' => 'ctganis@gmail.com',
            'user_password' => '0338869',
            'sms_receiver' => $to_numbers,
            'sms_text' => $sms_txt,
            'campaignType' => 'T',
        );
        
        $post_string = "";
        foreach( $post_values as $key => $value )
            { $post_string .= "$key=" . urlencode( $value ) . "&"; }
           $post_string = rtrim( $post_string, "& " );

          $request = curl_init($post_url);
          curl_setopt($request, CURLOPT_HEADER, 0);
          curl_setopt($request, CURLOPT_RETURNTRANSFER, 1);  
          curl_setopt($request, CURLOPT_POSTFIELDS, $post_string); 
          curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE);  
        $post_response = curl_exec($request);  
        curl_close ($request); 
      
        $response_array= explode("|", $post_response);

        $follow_up = $this->follow_up;

        $status_code = $response_array[0];
      //  dd($status_code);
        if($status_code==8){
            $status=0;
            $sms_id=0;
            // this condition for balance null
            $follow_up->res_msg_id = $sms_id;
            
            $follow_up->sent_status = $status;
            $follow_up->res_status = $status;
            $follow_up->company = 'smsinbd';
            $follow_up->res_txt_json = json_encode($response_array);
            $follow_up->msg_txt = $sms_txt;
            $follow_up->sent_masking = $sms_masking;
            $follow_up->res_error_txt = 'balance null';
            $follow_up->res_error_code = $status_code;
          
            $returned_balance = $this->returnBackSmsBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id);
            $follow_up->returned_charges = $returned_balance;//$sms_count;

        }else{

        
       // $sms_recever = $response_array[1];
        $sms_id = $response_array[2];
        // $buld_sms_id = $response_array[3];
        // $job_id = $response_array[4];
        $success_sms_count = $response_array[5];
        $current_credit = $response_array[6];

        $status = $success_sms_count >= 1?1:0;

        $follow_up->sent_status = $status;
        $follow_up->res_status = $status;
        $follow_up->company = 'smsinbd';
        $follow_up->res_txt_json = json_encode($response_array);
        $follow_up->msg_txt = $sms_txt;
        $follow_up->res_current_credit = $current_credit;
        $follow_up->sent_masking = $sms_masking;
        $follow_up->res_sms_count = $success_sms_count;

        if ($status) {
            $follow_up->res_msg_id = $sms_id;
            $follow_up->company_charged_from_edu = 0.00;

        } else {//error now return back balance to user
            // $returned_balance = $this->returnBackSmsBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id);
            // $follow_up->returned_charges = $returned_balance;
            
            $follow_up->res_error_txt = $status_code;
            $follow_up->res_error_code = $status_code;
        }
        // if fails number, return balance
        $munber_array= explode(",", $to_numbers);
        $fail_sms_count=count($munber_array)-$success_sms_count;
        
        if($fail_sms_count>=1){
            $fail_sms_cost=$fail_sms_count * $per_sms_cost;
            $returned_balance = $this->returnBackSmsBalance($fail_sms_cost, $sms_bearer, $sms_bearer_id);
            $follow_up->returned_charges = $returned_balance;//$sms_count;
        }
    }

        $follow_up->save();

        $time = Carbon::now()->toDateTimeString();

        $response = [];
        $response['followup_id'] = $follow_up->id;
        $response['sms_api_id'] = $sms_id ?? 0;
        $response['sms_company'] = 'smsinbd';
        $response['sms_sent_status'] = $status;
        $response['sent_time'] = date('Y-m-d H:i:s', strtotime($time));

        return $response;

    }


    public function sendSmsSmsInBd_old($numbers_array, $sms_data)//Sms in bd
    {
        //9 parameter needed to cal this function

        $sms_numbers = $numbers_array;
        $sms_txt = $sms_data['sms_txt'];
        $sms_count = $sms_data['sms_count'];
        $edu_charged_from_client = $sms_data['total_sms_charges'];
        $sms_type = $sms_data['sms_type'];
        $sms_masking = $sms_data['sms_masking'] ?? '8801552146120';//sms_in_bd default masking
        $sms_bearer = $sms_data['sms_bearer'];
        $sms_bearer_id = $sms_data['sms_bearer_id'];

        $masking = str_replace(" ", "%20", $sms_masking);


        $to_numbers = is_array($sms_numbers) ? implode(',', $sms_numbers) : $sms_numbers;
        $message_text_ue = urlencode($sms_txt);
        // $message_text = str_replace("[nl]", " ", $sms_txt);

        $message_text = str_replace("%5Bnl%5D", "%0A", $message_text_ue);
        $type = ($sms_type == 'unicode' ? 'unicode' : 'text');
        //\Log::info($message_text);
        // \Log::info('https://portal.smsinbd.com/smsapi?api_key=e10e34f061bcd073443cb1fee355f749c9d94a7c&type=' . $type . '&contacts=' . $to_numbers . '&senderid=' . $masking . '&msg=' . $message_text . '&method=api');
        $api_key = 'e10e34f061bcd073443cb1fee355f749c9d94a7c';

        
        $api_request = curl_init('https://portal.smsinbd.com/smsapi?api_key=' . $api_key . '&type=' . $type . '&contacts=' . $to_numbers . '&senderid=' . $masking . '&msg=' . $message_text . '&method=api');
        curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        curl_setopt($api_request, CURLOPT_POST, false);
        $result = curl_exec($api_request);
        $array = json_decode(preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $result), true);

        $error_msg = null;
        if (curl_errno($api_request)) {
            $error_msg = curl_error($api_request);
            $array['status'] = $error_msg;
        }
        curl_close($api_request);


//=====api responded
        $this->finished();

        //dd($array);

        /* array:3 [▼
   "CamID" => "742157141311679"
   "status" => "SUCCESS"
   "cost" => "0.3800
 ]"

           array:2 [▼
  "error_code" => 1003
  "status" => "ERROR"
]
    */


        $org_message_text = str_replace("[nl]", " ", $sms_txt);


        $status = $array['status'] == 'SUCCESS' ? 1 : 0;


        $follow_up = $this->follow_up;

        if ($status) {
            //do nothing now

        } else {//error now return back balance to user

            $returned_balance = $this->returnBackSmsBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id);
            $follow_up->returned_charges = $returned_balance;
            $follow_up->res_error_txt = $array['status'] ?? 0;
            $follow_up->res_error_code = $array['error_code'] ?? 0;
            $follow_up->sent_status = 0;

        }

        $status_txt = $array['status'];//ERROR || SUCCESS
        $company_charged = $array['cost'] ?? 0;


        $follow_up->sent_masking = $sms_masking;
        $follow_up->res_txt_json = json_encode($array);

        $follow_up->msg_txt = $org_message_text;
        $follow_up->res_sms_count = $sms_count;
        $follow_up->res_current_credit = 0;//not sent by smsinbd


        $follow_up->res_msg_id = $array['CamID'] ?? 0;
        $follow_up->company_charged_from_edu = $company_charged;


        $follow_up->res_status = $status;

        $follow_up->save();


        $time = Carbon::now()->toDateTimeString();

        $response = [];
        $response['followup_id'] = $follow_up->id;
        $response['sms_api_id'] = $array['CamID'] ?? 0;
        $response['sms_company'] = 'smsinbd';
        $response['sms_sent_status'] = $status;
        $response['sent_time'] = date('Y-m-d H:i:s', strtotime($time));

//dd($response);
        return $response;

    }


    public function sendSmsMobireach($numbers_array, $sms_data)
    {

        //   dd($sms_data);

        $sms_numbers = $numbers_array;
        $sms_txt = $sms_data['sms_txt'];
        $sms_count = $sms_data['sms_count'];
        $edu_charged_from_client = $sms_data['total_sms_charges'];
        $sms_type = $sms_data['sms_type'];
        $sms_masking = $sms_data['sms_masking'] ??  '8801844542995';//mobireach default masking EDU%20WORLD
        $sms_bearer = $sms_data['sms_bearer'];
        $sms_bearer_id = $sms_data['sms_bearer_id'];
        $masking = str_replace(" ", "%20", $sms_masking);


        $to_numbers = is_array($sms_numbers) ? implode(',', $sms_numbers) : $sms_numbers;
        $message_text1 = urlencode($sms_txt);

        $message_text = str_replace("%5Bnl%5D", "%0A", $message_text1);

        //dd( $message_text1.' '.$message_text);
        // https://api.mobireach.com.bd/SendTextMessage?Username=the_world&Password=Nuruddin@123&From=EDU%20WORLD&To=8801675020403&Message=testmessage%20greetings%20From%20Edu%20world

        $api_request = curl_init('https://api.mobireach.com.bd/SendTextMessage?Username=the_world&Password=Theworld@123?&From=' . $masking . '&To=' . $to_numbers . '&Message=' . $message_text);
        curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        curl_setopt($api_request, CURLOPT_POST, false);
        $result = curl_exec($api_request);
        $xml = simplexml_load_string($result);
        $error_msg = null;
        if (curl_errno($api_request)) {
            $error_msg = curl_error($api_request);
        }
        curl_close($api_request);


        $total_number = count($sms_numbers);
        $per_sms_cost = ($edu_charged_from_client / $total_number);

        $number = 0;
        $this->finished();
        $status = 0;


        if ($xml && count($xml) > 0) {
            foreach ($xml as $key => $sms_response) {

                $msg_id = $sms_response->MessageId;
                $status = $sms_response->Status;
                $status_txt = $sms_response->StatusText;
                $err_code = $sms_response->ErrorCode;
                $err_txt = $sms_response->ErrorText;
                $sms_count = (int)$sms_response->SMSCount;
                $current_credit = $sms_response->CurrentCredit;

                $follow_up = $this->follow_up;

                $follow_up->edu_charged_from_client = $per_sms_cost;
                $follow_up->msg_numbers = $sms_numbers[$number];


                if ($sms_response->Status != 0) {//error
                    $returned_balance = $this->returnBackSmsBalance($per_sms_cost, $sms_bearer, $sms_bearer_id);
                    $follow_up->edu_charged_from_client = $returned_balance;
                    $follow_up->returned_charges = $returned_balance;
                    $follow_up->msg_numbers = is_array($sms_numbers) ? implode(',', $sms_numbers) : $sms_numbers;
                    $follow_up->sent_status = 0;

                }


                $follow_up->sent_masking = $sms_masking;

                $follow_up->res_txt_json = json_encode($sms_response);

                $follow_up->company_charged_from_edu = .40;
                $follow_up->res_msg_id = $msg_id;
                $follow_up->res_status = $status;
                $follow_up->res_error_code = $err_code;
                $follow_up->res_error_txt = $err_txt;
                $follow_up->res_sms_count = $sms_count;
                $follow_up->res_current_credit = $current_credit;
                $follow_up->institution_type = $sms_bearer;
                $follow_up->institution_id = $sms_bearer_id;
                $follow_up->save();
                $number++;
            }


            if (((int)$xml->ServiceClass->Status) == 0) {//mobireach response 0 if success
                $status = 1;
            } else {
                $status = 0;
            }


        } else {
            $follow_up = $this->follow_up;
            $follow_up->sent_masking = $sms_masking;
            $follow_up->company_charged_from_edu = .40;

            $returned_balance = $this->returnBackSmsBalance($per_sms_cost, $sms_bearer, $sms_bearer_id);
            $follow_up->edu_charged_from_client = $returned_balance;
            $follow_up->returned_charges = $returned_balance;
            $follow_up->msg_numbers = is_array($sms_numbers) ? implode(',', $sms_numbers) : $sms_numbers;
            $follow_up->res_status = $status;
            $follow_up->res_txt_json = $error_msg ? json_encode($error_msg) : 'no';
            $follow_up->sent_status = 0;

            $follow_up->save();

        }


        $time = Carbon::now()->toDateTimeString();

        $response = [];
        $response['followup_id'] = $this->follow_up->id;
        $response['sms_api_id'] = $xml->ServiceClass->MessageId ?? 0;
        $response['sms_company'] = 'mobireach';
        $response['sms_sent_status'] = $status;
        $response['sent_time'] = date('Y-m-d H:i:s', strtotime($time));


        return $response;
        /*ArrayOfServiceClass>
       <ServiceClass>
       <MessageId>1573371793793529</MessageId>
       <Status>0</Status>
       <StatusText>success</StatusText>
       <ErrorCode>0</ErrorCode>
       <ErrorText/>
       <SMSCount>1</SMSCount>
       <CurrentCredit>38.76</CurrentCredit>
       </ServiceClass>
       </ArrayOfServiceClass>*/
        /*
                +"ServiceClass": SimpleXMLElement {#1961 ▼
                +"MessageId": "0"
                +"Status": "-1"
                +"StatusText": "Error occurred"
                +"ErrorCode": "1504"
                +"ErrorText": "auth_fail"
                +"SMSCount": "2"
                +"CurrentCredit": "0"*/
    }


    public function checkSmsStatus($msg_id)
    {


        $api_request = curl_init('https://api.mobireach.com.bd/GetMessageStatus?Username=the_world&Password=Theworld@123?&MessageId=' . $msg_id);
        curl_setopt($api_request, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($api_request, CURLINFO_HEADER_OUT, true);
        curl_setopt($api_request, CURLOPT_POST, false);
        $result = curl_exec($api_request);
        $sms_response = simplexml_load_string($result);


        //  dd($sms_response->ServiceClass);

        $return = $sms_response->ServiceClass;


        return $return;


    }


    public function returnBackSmsBalance($edu_charged_from_client, $sms_bearer, $sms_bearer_id)
    {

        if ($sms_bearer == 'site') {
            SiteMembership::
            where('site_id', $sms_bearer_id)
                ->where('status', 1)
                ->increment('sms_balance', $edu_charged_from_client);

        } elseif ($sms_bearer == 'site_group') {

        } elseif ($sms_bearer == 'company') {

        }

        return $edu_charged_from_client;

    }


}