<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAcademicTransportIdColumnToStudentHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('student_histories', function (Blueprint $table) {
            $table->integer('academic_transport_id')->nullable()->after('academic_residence_id');
        });


        Schema::table('users', function (Blueprint $table) {
            $table->integer('academic_transport_id')->nullable()->after('academic_residence_id');
        });



        Schema::table('site_student_fee_generates', function (Blueprint $table) {

            $table->dropColumn('user_id');
            $table->dropColumn('academic_version_id');
            $table->dropColumn('academic_shift_id');
            $table->dropColumn('academic_class_id');
            $table->dropColumn('academic_department_id');
            $table->dropColumn('academic_section_id');
            $table->dropColumn('academic_class_group_id');
            $table->dropColumn('academic_session_id');
            $table->dropColumn('academic_fee_head_id');
            $table->dropColumn('academic_fee_group_id');
            $table->dropColumn('academic_fee_sub_head_id');
            $table->dropColumn('academic_year_id');
            $table->dropColumn('academic_group_id');


            $table->integer('student_history_id')->nullable()->after('id');
            $table->integer('site_student_fee_fine_allocation_id')->nullable()->after('student_history_id');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('student_histories', function (Blueprint $table) {
            //
        });
    }
}
