<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEduSmsFollowUps extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('edu_sms_follow_ups', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('msg_txt')->nullable();
            $table->string('msg_numbers',10000)->nullable();
            $table->string('res_msg_id')->nullable();
            $table->boolean('res_status')->nullable();
            $table->string('res_status_txt')->nullable();
            $table->string('res_error_code')->nullable();
            $table->string('res_error_txt')->nullable();
            $table->tinyInteger('res_sms_count')->nullable();
            $table->float('res_current_credit')->nullable();
            $table->string('institution_type')->nullable();
            $table->integer('institution_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edu_sms_follow_ups');
    }
}
