<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSitePaymentInvoiceAndDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('edu_site_invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('order_id')->nullable();
            $table->string('invoice_no',100)->nullable();
            $table->date('invoice_date')->nullable();
            $table->date('due_date')->nullable();
            $table->decimal('sub_total',10,2)->nullable();
            $table->string('tax_percentage')->default(0)->nullable();
            $table->decimal('total_tax',10,2)->default(0)->nullable();
            $table->decimal('total_after_tax',10,2)->default(0)->nullable();
            $table->string('discount_type',20)->nullable();
            $table->decimal('discount_figure',10,2)->default(0)->nullable();
            $table->decimal('discount_amount',10,2)->default(0)->nullable();
            $table->decimal('previous_due',10,2)->nullable();
            $table->decimal('grand_total',10,2)->nullable();
            $table->decimal('amount_paid',10,2)->default(0)->nullable();
            $table->decimal('amount_due',10,2)->default(0)->nullable();
            $table->string('notify')->nullable();
            $table->string('status_code')->nullable();
            $table->string('note')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('created_by')->nullable();

            $table->boolean('status')->default(1);

            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('edu_site_invoice_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('invoice_id');
            $table->bigInteger('item_details_id')->nullable();
            $table->string('month_for',20)->nullable();
            $table->decimal('item_quantity',10,2)->nullable();
            $table->decimal('item_price',10,2)->nullable();
            $table->string('tax_percentage')->default(0)->nullable();
            $table->decimal('total_tax',10,2)->default(0)->nullable();
            $table->decimal('item_final_amount',10,2)->default(0)->nullable();

            $table->timestamps();
        });

        Schema::create('edu_site_invoice_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('site_invoice_id');
            $table->string('status_code')->nullable();
            $table->string('description')->nullable();

            $table->timestamps();
        });

        Schema::create('edu_site_invoice_payments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('invoice_id');
            $table->string('account_code',50)->nullable()->default('cash');
            $table->string('payment_method',50)->nullable()->default('cash');
            $table->string('reference_no')->nullable();
            $table->decimal('paid_amount',10,2)->nullable();
            $table->string('status_code',20)->nullable();
            $table->date('payment_date')->nullable();
            $table->integer('site_id')->nullable();
            $table->string('description')->nullable();
            $table->integer('received_by')->nullable();
            $table->boolean('status')->default(1);

            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edu_site_invoices');
        Schema::dropIfExists('edu_site_invoice_details');
        Schema::dropIfExists('edu_site_invoice_histories');
        Schema::dropIfExists('edu_site_invoice_payments');
    }
}
