<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateItemDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {


        Schema::create('edu_item_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('category_code')->nullable();
            $table->string('item_name')->nullable();
            $table->string('item_code')->nullable();
            $table->decimal('sales_price')->nullable();
            $table->decimal('purchase_price')->nullable();
            $table->decimal('tax_percentage')->default(0)->nullable();
            $table->boolean('monthly')->nullable()->default(0);
            $table->boolean('status')->nullable()->default(1);
            $table->integer('created_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edu_item_details');
    }
}
