<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSmsCutAmouttositemmembseshipatable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_memberships', function (Blueprint $table) {
            $table->decimal('per_sms_cost')->after('sms_bearer')->default(0);
           $table->integer('sms_bearer_id')->after('sms_bearer')->nullable();
            $table->decimal('sms_in_stock')->change();
            $table->string('sms_send_type')->default('non_masking');
            $table->renameColumn('sms_in_stock','sms_balance')->default(0);
        });

        Schema::table('edu_site_invoices', function (Blueprint $table) {
            $table->bigInteger('carried_invoice_id')->after('invoice_no')->nullable();
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {


        Schema::table('site_memberships', function (Blueprint $table) {
            $table->dropColumn('per_sms_cost');
            $table->dropColumn('sms_bearer_id');
            $table->dropColumn('sms_send_type');
           $table->renameColumn('sms_balance','sms_in_stock');

        });

        Schema::table('edu_site_invoices', function (Blueprint $table) {
            $table->dropColumn('carried_invoice_id');
        });
    }
}
