<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddgovtcodetocountryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::table('countries', function (Blueprint $table) {
            $table->string('govt_code', 20)->after('id')->nullable();
            $table->boolean('status')->change();
        });

        Schema::table('country_translations', function (Blueprint $table) {
            $table->dropColumn('site_id');
        });

        Schema::table('divisions', function (Blueprint $table) {
            $table->string('govt_code', 20)->change();
            $table->boolean('status')->change();
        });
        Schema::table('districts', function (Blueprint $table) {
            $table->dropColumn('country_id');
            $table->string('govt_code', 20)->change();

            $table->boolean('status')->change();
        });

        Schema::table('thanas', function (Blueprint $table) {
            $table->dropColumn('country_id');
            $table->dropColumn('division_id');
            $table->string('govt_code', 20)->change();

            $table->boolean('status')->change();
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('countries', function (Blueprint $table) {
            //
        });
    }
}
