<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteLeavePoliciesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_leave_policies', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_leave_type_id')->nullable();
            $table->integer('academic_leave_category_id')->nullable();
            $table->string('policy_title', 260)->nullable();
            $table->integer('leave_days')->nullable();
            $table->boolean('add_to_next_year')->nullable();
            $table->boolean('wages_payable')->nullable();
            $table->integer('employee_designation_id')->nullable();
            $table->text('policy_details')->nullable();
            $table->boolean('status')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_leave_policies');
    }
}
