<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteEmployeeLeaveGeneratesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_employee_leave_generates', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_leave_policy_id')->nullable();
            $table->integer('employee_previous_history_id')->nullable();
            $table->integer('employee_history_id')->nullable();
            $table->integer('academic_fiscal_year_id')->nullable();
            $table->integer('previous_leave_days_remaining')->nullable();
            $table->integer('leave_days')->nullable();
            $table->boolean('status')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_employee_leave_generates');
    }
}
