<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteEmployeeLeaveHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_employee_leave_histories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_employee_leave_generate_id')->nullable();
            $table->integer('employee_history_id')->nullable();
            $table->integer('spend_leave_days')->nullable();
            $table->integer('remaining_days')->nullable();
            $table->date('from_date')->nullable();
            $table->date('to_date')->nullable();
            $table->string('reason')->nullable();
            $table->string('approved_or_cancelled_by')->nullable();
            $table->date('request_date')->nullable();
            $table->date('approve_date')->nullable();
            $table->date('cancel_date')->nullable();
            $table->integer('leave_status')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_employee_leave_histories');
    }
}
