<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSwapCancelColumnToRoutineDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_routine_swap_cancels', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('swap_cancel_date');
            $table->integer('allocation_id');
            $table->integer('employee_id')->default(0);
            $table->integer('subject_id')->default(0);
            $table->integer('room_id')->default(0);
            $table->boolean('is_cancelled')->default(0);
            $table->string('swap_cancel_reason')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_routine_swap_cancels');
    }
}
