<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateResultTypeAcademicAndSiteAndSetting extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academic_result_primary_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });


        Schema::create('academic_result_combine_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
        });


        Schema::table('site_info_settings', function (Blueprint $table) {
            $table->string('academic_result_primary_type_ids')->nullable();
            $table->string('academic_result_combine_type_ids')->nullable();
        });


        Schema::create('site_result_primary_settings', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();

            $table->integer('academic_result_primary_type_id')->nullable();
            $table->integer('examination_id')->nullable();
            $table->double('marks_percentage')->nullable();
            $table->boolean('is_average')->default(false);
            $table->integer('how_many_subject_fail_allow')->default(false);
            $table->boolean('status')->default(true);
            $table->integer('site_id');
            $table->timestamps();
        });

        Schema::create('site_result_combine_settings', function (Blueprint $table) {
            $table->bigIncrements('id');

            $table->integer('academic_group_id')->nullable();
            $table->integer('academic_year_id')->nullable();
            $table->integer('academic_version_id')->nullable();
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_department_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();

            $table->integer('result_academic_class_ids')->nullable();
            $table->integer('academic_result_combine_type_id')->nullable();
            $table->integer('academic_result_primary_type_id')->nullable();
            $table->double('marks_percentage')->nullable();
            $table->boolean('is_average')->default(false);
            $table->boolean('fail_allow')->default(false);
            $table->boolean('status')->default(true);
            $table->integer('site_id');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('result_type_academic_and_site_and_setting');
    }
}
