<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteSmsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_sms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('track_number');
            $table->string('doc_number')->nullable();
            $table->string('sms_title');
            $table->string('sms_description');
            $table->dateTime('sms_send_time');
            $table->string('type',10);
            $table->boolean('status')->default(1);
            $table->integer('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_sms');
    }
}
