<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddReturnMoneyColumnToSsmFollowupTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('edu_sms_follow_ups', function (Blueprint $table) {
           $table->decimal('returned_charges')->nullable()->default(0)->after('edu_charged_from_client');
           $table->mediumText('msg_numbers')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('edu_sms_follow_ups', function (Blueprint $table) {
            $table->dropColumn('returned_charges');
        });
    }
}
