<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentFeeFinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_fee_fines', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_fee_demand_slip_details_id')->nullable();
            $table->decimal('fine_amount',9,2)->nullable();
            $table->boolean('status')->default(1);
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_fee_fines');
    }
}
