<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSitePrimaryResultDetailStoreTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('site_student_primary_result_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_history_id')->nullable();
            $table->integer('site_result_primary_setting_id')->nullable();
            $table->integer('academic_result_primary_type_id')->nullable();
            $table->double('gpa')->nullable();
            $table->string('grade')->nullable();
            $table->integer('fail_subject_count')->nullable();
            $table->text('result_detail')->nullable();
            $table->text('table_header')->nullable();
            $table->boolean('status')->default(true);
            $table->integer('site_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_primary_result_detail_store');
    }
}
