<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddMotherOccupationEmailNumberToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->renameColumn('parent_occupation_id', 'father_occupation_id');
            $table->renameColumn('parent_yearly_income', 'father_yearly_income');
            $table->renameColumn('parent_contact_number', 'father_contact_number');
            $table->renameColumn('parent_email', 'father_email');
            $table->integer('mother_occupation_id')->nullable()->after('blood_group_id');
            $table->integer('mother_yearly_income')->nullable()->after('mother_occupation_id');
            $table->string('mother_contact_number', 20)->nullable()->after('mother_yearly_income');
            $table->string('mother_email')->nullable()->after('mother_contact_number');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
}
