<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddGeneralMarkinglessSubjectIdsColumnToSiteStudentRegistrationApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_student_registration_applications', function (Blueprint $table) {
            $table->boolean('approve_as_student')->default(false);
            $table->integer('site_base_student_registration_declare_id')->nullable();
        });


        Schema::table('users', function (Blueprint $table) {
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('site_student_registration_application_id')->nullable();
        });


        Schema::rename('site_base_student_registration_declare', 'site_base_student_registration_declares');


        Schema::table('student_histories', function (Blueprint $table) {
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->integer('site_student_registration_application_id')->nullable();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_student_registration_applications', function (Blueprint $table) {
            //
        });
    }
}
