<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTcSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_tc_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('setting_name',192)->nullable();
            $table->string('heading',192)->nullable();
            $table->string('body_starting',250)->nullable();
            $table->string('body_ending',350)->nullable();
            $table->string('conclusion',400)->nullable();
            $table->string('authority_name',192)->nullable();
            $table->string('authority_signature',192)->nullable();
            $table->date('create_date')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->boolean('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tc_settings');
    }
}
