<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddLeaveDateLeaveApprovedLeaveAprroveBySiteStudentAttendanceLeaveAbsents extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::rename('site_student_absent_details','site_student_attendance_absents');

        Schema::create('site_student_attendance_leaves', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('student_history_id');
            $table->date('from_date')->nullable();
            $table->date('to_date')->nullable();
            $table->tinyInteger('total_days')->nullable();
            $table->boolean('approved')->default(0);
            $table->string('leave_status')->default('pending');
            $table->string('leave_reason')->default('No Reason');
            $table->dateTime('leave_applied_time')->nullable();
            $table->integer('approved_by')->nullable();
            $table->dateTime('approved_time')->nullable();
            $table->boolean('status')->default(1);
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();

        });
        Schema::create('site_student_attendance_leave_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('site_student_attendance_leave_id');
            $table->bigInteger('student_history_id')->nullable();
            $table->date('leave_date')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_attendance_leaves');
        Schema::dropIfExists('site_student_attendance_leave_details');
    }
}
