<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteBaseExamRoomSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_base_exam_room_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('building_id');
            $table->integer('floor_id');
            $table->integer('room_id');
            $table->integer('column_position');
            $table->integer('seat_number');
            $table->integer('site_id');
            $table->boolean('status');
            $table->timestamps();
        });

        Schema::table('site_rooms', function (Blueprint $table) {

            $table->integer('column_number')->after('room_name')->nullable();
            $table->string('door_seat_orientation', 10)->after('column_number')->nullable();
            $table->integer('total_exam_seat')->after('door_seat_orientation')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_base_exam_room_settings');
    }
}
