<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMessagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('website_messages', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('message_from', 20)->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('site_id')->nullable();
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('website_messages');
    }
}
