<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDirectResultInputColumnToSiteExaminationExamTypeSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('site_examination_exam_type_settings', function (Blueprint $table) {
            $table->boolean('direct_result_input')->default(false)->after('academic_exam_type_id');
        });

        Schema::table('site_info_settings', function (Blueprint $table) {
            $table->renameColumn('academic_result_grade_ids', 'academic_result_system_ids')->change();
        });

        Schema::table('site_result_system_settings', function (Blueprint $table) {
            $table->boolean('pass_fail_status')->after('point_to');
        });


        Schema::create('site_testimonial_result', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('passing_year');
            $table->integer('student_history_id');
            $table->integer('academic_result_primary_type_id')->nullable();
            $table->integer('academic_result_combine_type_id')->nullable();
            $table->double('gpa')->nullable();
            $table->integer('academic_result_system_id')->nullable();
            $table->boolean('pass_fail_status')->nullable();
            $table->integer('testimonial_created_by')->nullable();
            $table->integer('testimonial_updated_by')->nullable();
            $table->boolean('status')->default(true);
            $table->integer('site_id');
            $table->timestamps();
        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('site_examination_exam_type_settings', function (Blueprint $table) {
            //
        });
    }
}
