<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteAccountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_accounts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_accounts_ledger_id')->nullable();
            $table->float('debit_amount',9,2)->default(0);
            $table->float('credit_amount',9,2)->default(0);
            $table->integer('site_id')->nullable();
            $table->integer('site_group_id')->nullable();
            $table->integer('academic_group_id')->nullable();
            $table->integer('created_by');
            $table->date('created_date');
            $table->boolean('status');
            $table->string('proprietor_access_key')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_accounts');
    }
}
