<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOnlinePaymentCompanyTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('academic_payment_types', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('name_key');
            $table->timestamps();
        });

        Schema::create('academic_online_payment_methods', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('name_key');
            $table->timestamps();
        });

        Schema::create('academic_banks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('name_key');
            $table->timestamps();
        });


        Schema::table('site_student_admission_declares', function (Blueprint $table) {
            $table->boolean('check_with_roll_number')->default(false);
            $table->boolean('check_with_online_transaction_id')->default(false);
            $table->boolean('terms_condition_show_top')->default(false);
            $table->boolean('terms_condition_show_bellow')->default(false);

            $table->string('education_qualification_ids')->nullable();
            $table->string('admission_form_language');
            $table->integer('academic_payment_type_id')->nullable();
            $table->string('payment_company_ids')->nullable();
            $table->longText('term_condition')->nullable();
        });



    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('online_payment_company');
    }
}
